/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.WordCap;
import java.util.function.UnaryOperator;

public class WordCapAdapter
implements UnaryOperator<WordCap> {
    private boolean toLowercase = false;
    private boolean ignoreCapitalization = false;

    public WordCapAdapter() {
    }

    public WordCapAdapter(boolean toLowercase, boolean ignoreCapitalization) {
        this.toLowercase = toLowercase;
        this.ignoreCapitalization = ignoreCapitalization;
    }

    @Override
    public WordCap apply(WordCap wordCap) {
        String word = wordCap.getWord();
        boolean isCapitalized = wordCap.isCapitalized();
        if (this.toLowercase) {
            word = word.toLowerCase();
        }
        if (this.ignoreCapitalization) {
            isCapitalized = false;
        }
        return new WordCap(word, isCapitalized);
    }

    public boolean isToLowercase() {
        return this.toLowercase;
    }

    public void setToLowercase(boolean toLowercase) {
        this.toLowercase = toLowercase;
    }

    public boolean isIgnoreCapitalization() {
        return this.ignoreCapitalization;
    }

    public void setIgnoreCapitalization(boolean ignoreCapitalization) {
        this.ignoreCapitalization = ignoreCapitalization;
    }
}

