/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.tuples.WordCap;
import java.util.function.Predicate;

public class WordCapFilter
implements Predicate<WordCap> {
    private boolean filterCapitalized = false;
    private boolean filterNotCapitalized = false;

    public WordCapFilter() {
    }

    public WordCapFilter(boolean filterCapitalized, boolean filterNotCapitalized) {
        this.filterCapitalized = filterCapitalized;
        this.filterNotCapitalized = filterNotCapitalized;
    }

    @Override
    public boolean test(WordCap wordCap) {
        return !(this.filterCapitalized && wordCap.isCapitalized() || this.filterNotCapitalized && !wordCap.isCapitalized());
    }

    public boolean isFilterCapitalized() {
        return this.filterCapitalized;
    }

    public void setFilterCapitalized(boolean filterCapitalized) {
        this.filterCapitalized = filterCapitalized;
    }

    public boolean isFilterNotCapitalized() {
        return this.filterNotCapitalized;
    }

    public void setFilterNotCapitalized(boolean filterNotCapitalized) {
        this.filterNotCapitalized = filterNotCapitalized;
    }
}

