/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tnt;

import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.utilities.Strings;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class WordPosFrequencies {
    private final Map<String, Map<PartOfSpeech, Integer>> posFrequenciesForWord;
    private final Map<PartOfSpeech, Integer> overallPosFrequencies;
    private int totalWords;

    WordPosFrequencies(Map<String, Map<PartOfSpeech, Integer>> posFrequenciesForWord, Map<PartOfSpeech, Integer> overallPosFrequencies, int totalWords) {
        this.posFrequenciesForWord = posFrequenciesForWord;
        this.overallPosFrequencies = overallPosFrequencies;
        this.totalWords = totalWords;
    }

    WordPosFrequencies() {
        this(new HashMap<String, Map<PartOfSpeech, Integer>>(), new EnumMap<PartOfSpeech, Integer>(PartOfSpeech.class), 0);
    }

    static WordPosFrequencies bySumming(Map<String, Map<PartOfSpeech, Integer>> posFrequenciesForWord) {
        Map<PartOfSpeech, Integer> overallPosFrequencies = posFrequenciesForWord.values().stream().flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum));
        int totalWords = overallPosFrequencies.values().stream().mapToInt(v -> v).sum();
        return new WordPosFrequencies(posFrequenciesForWord, overallPosFrequencies, totalWords);
    }

    int getTotalWords() {
        return this.totalWords;
    }

    int frequencyOfWordAndPartOfSpeech(String word, PartOfSpeech partOfSpeech) {
        Map<PartOfSpeech, Integer> wordPosFrequencies = this.posFrequenciesForWord.get(word);
        return wordPosFrequencies == null ? 0 : wordPosFrequencies.getOrDefault((Object)partOfSpeech, 0);
    }

    int frequencyOfWord(String word) {
        return this.posFrequenciesForWord.get(word).values().stream().mapToInt(i -> i).sum();
    }

    double probabilityOfWord(String word) {
        return (double)this.frequencyOfWord(word) / (double)this.totalWords;
    }

    double probabilityOfPartOfSpeech(PartOfSpeech partOfSpeech) {
        return (double)this.frequencyOfPartOfSpeech(partOfSpeech) / (double)this.totalWords;
    }

    int frequencyOfPartOfSpeech(PartOfSpeech tag) {
        return this.overallPosFrequencies.getOrDefault((Object)tag, 0);
    }

    Set<String> getWords() {
        return this.posFrequenciesForWord.keySet();
    }

    Set<PartOfSpeech> partsOfSpeech() {
        return this.overallPosFrequencies.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toCollection(() -> EnumSet.noneOf(PartOfSpeech.class)));
    }

    WordPosFrequencies onlyWordsOccurringUpTo(int times) {
        Map<String, Map<PartOfSpeech, Integer>> filtered = this.posFrequenciesForWord.entrySet().stream().filter(e -> ((Map)e.getValue()).values().stream().mapToInt(v -> v).sum() <= times).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return WordPosFrequencies.bySumming(filtered);
    }

    WordPosFrequencies expandSuffixes(int length) {
        WordPosFrequencies wordPosFrequencies = new WordPosFrequencies();
        for (Map.Entry<String, Map<PartOfSpeech, Integer>> entry : this.posFrequenciesForWord.entrySet()) {
            List suffixes = Strings.generateSuffixes(entry.getKey(), length).collect(Collectors.toList());
            Map<PartOfSpeech, Integer> counts = entry.getValue();
            for (String suffix : suffixes) {
                wordPosFrequencies.addCounts(suffix, counts);
            }
        }
        return wordPosFrequencies;
    }

    Map<Integer, WordPosFrequencies> byWordLength() {
        HashMap<Integer, Map> builder = new HashMap<Integer, Map>();
        for (String s : this.getWords()) {
            int length = s.length();
            builder.compute(length, (k, v) -> {
                if (v == null) {
                    v = new HashMap<String, Map<PartOfSpeech, Integer>>();
                }
                v.put(s, this.posFrequenciesForWord.get(s));
                return v;
            });
        }
        return builder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> WordPosFrequencies.bySumming((Map)e.getValue())));
    }

    void addCounts(String word, Map<PartOfSpeech, Integer> m) {
        for (Map.Entry<PartOfSpeech, Integer> entry : m.entrySet()) {
            this.addCount(word, entry.getKey(), entry.getValue());
        }
    }

    void addCount(String word, PartOfSpeech partOfSpeech, int count) {
        this.posFrequenciesForWord.compute(word, (key, value) -> {
            EnumMap<PartOfSpeech, Integer> partOfSpeechFrequencies = value;
            if (partOfSpeechFrequencies == null) {
                partOfSpeechFrequencies = new EnumMap<PartOfSpeech, Integer>(PartOfSpeech.class);
            }
            partOfSpeechFrequencies.merge(partOfSpeech, count, Integer::sum);
            return partOfSpeechFrequencies;
        });
        this.overallPosFrequencies.merge(partOfSpeech, count, Integer::sum);
        this.totalWords += count;
    }

    double probabilityOfPartOfSpeechConditionalOnWord(String word, PartOfSpeech partOfSpeech) {
        return (double)this.frequencyOfWordAndPartOfSpeech(word, partOfSpeech) / (double)this.frequencyOfWord(word);
    }
}

