/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tokenization;

import edu.umn.biomedicus.ExtensionsKt;
import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.TokenCandidate;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ledu/umn/biomedicus/tokenization/DetectParseTokens;", "Ledu/umn/nlpengine/DocumentTask;", "()V", "run", "", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class DetectParseTokens
implements DocumentTask {
    public void run(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex candidates = $receiver$iv.labelIndex(TokenCandidate.class);
        Document $receiver$iv2 = document;
        Labeler labeler = $receiver$iv2.labeler(ParseToken.class);
        String text = document.getText();
        Iterable $receiver$iv3 = (Iterable)ExtensionsKt.sentences(document);
        for (Object element$iv : $receiver$iv3) {
            Sentence it = (Sentence)((Object)element$iv);
            List insideSentence = candidates.inside((TextRange)it).asList();
            TokenCandidate lastOrNull = (TokenCandidate)((Object)CollectionsKt.lastOrNull((List)insideSentence));
            Iterable $receiver$iv4 = insideSentence;
            for (Object element$iv2 : $receiver$iv4) {
                TokenCandidate candidate = (TokenCandidate)((Object)element$iv2);
                if (Intrinsics.areEqual((Object)((Object)lastOrNull), (Object)((Object)candidate)) && candidate.endsWithPeriod(text)) {
                    Span notPeriod = new Span(candidate.getStartIndex(), candidate.getEndIndex() - 1);
                    String coveredText = notPeriod.coveredString(text);
                    labeler.add((Label)new ParseToken((TextRange)notPeriod, coveredText, false));
                    labeler.add((Label)new ParseToken(candidate.getEndIndex() - 1, candidate.getEndIndex(), ".", candidate.hasSpaceAfter(text)));
                    continue;
                }
                String coveredText = candidate.coveredString(text);
                boolean hasSpaceAfter = candidate.hasSpaceAfter(text);
                labeler.add((Label)new ParseToken((TextRange)candidate, coveredText, hasSpaceAfter));
            }
        }
    }
}

