/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.tokenization;

import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.TermToken;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class TermTokenMerger
implements Iterator<TermToken> {
    private static final Set<Character> MERGE = new HashSet<Character>(Arrays.asList(Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('\''), Character.valueOf('_')));
    private final List<Token> running = new ArrayList<Token>();
    private final Iterator<ParseToken> iterator;
    @Nullable
    private TermToken next;

    public TermTokenMerger(Iterator<ParseToken> iterator2) {
        this.iterator = iterator2;
        this.findNext();
    }

    public TermTokenMerger(LabelIndex<ParseToken> parseTokens) {
        this(parseTokens.iterator());
    }

    private void findNext() {
        this.next = null;
        while (this.next == null && this.iterator.hasNext()) {
            Token token = this.iterator.next();
            if (this.running.size() == 0) {
                this.running.add(token);
                continue;
            }
            Token lastToken = this.running.get(this.running.size() - 1);
            String lastTokenText = lastToken.getText();
            char lastTokenLastChar = lastTokenText.charAt(lastTokenText.length() - 1);
            char curTokenFirstChar = token.getText().charAt(0);
            if (lastToken.getHasSpaceAfter() || !MERGE.contains(Character.valueOf(curTokenFirstChar)) && !MERGE.contains(Character.valueOf(lastTokenLastChar))) {
                this.makeTermToken();
            }
            this.running.add(token);
        }
        if (this.next == null && !this.running.isEmpty()) {
            this.makeTermToken();
        }
    }

    private void makeTermToken() {
        if (this.running.size() == 0) {
            return;
        }
        StringBuilder tokenText = new StringBuilder();
        for (Token token : this.running) {
            tokenText.append(token.getText());
        }
        Token lastToken = this.running.get(this.running.size() - 1);
        boolean hasSpaceAfter = lastToken.getHasSpaceAfter();
        Span span = new Span(this.running.get(0).getStartIndex(), lastToken.getEndIndex());
        this.next = new TermToken((TextRange)span, tokenText.toString(), hasSpaceAfter);
        this.running.clear();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public TermToken next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        TermToken copy = this.next;
        this.findNext();
        return copy;
    }
}

