/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.util;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.sentences.TextSegment;
import edu.umn.biomedicus.tokenization.EmbeddingToken;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentsProcessor;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.TextRange;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ledu/umn/biomedicus/util/Word2VecTrainingWriter;", "Ledu/umn/nlpengine/DocumentsProcessor;", "outputFile", "", "(Ljava/lang/String;)V", "outputWriter", "Ljava/io/BufferedWriter;", "done", "", "process", "document", "Ledu/umn/nlpengine/Document;", "biomedicus-core"})
public final class Word2VecTrainingWriter
implements DocumentsProcessor {
    private final BufferedWriter outputWriter;

    public void process(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Document $receiver$iv = document;
        LabelIndex segments = $receiver$iv.labelIndex(TextSegment.class);
        Document $receiver$iv2 = document;
        LabelIndex tokens = $receiver$iv2.labelIndex(EmbeddingToken.class);
        for (TextSegment segment : segments) {
            for (EmbeddingToken token : tokens.inside((TextRange)segment)) {
                CharSequence charSequence = token.getText();
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                this.outputWriter.append(token.getText() + ' ');
            }
            this.outputWriter.newLine();
        }
    }

    public void done() {
        this.outputWriter.close();
    }

    @Inject
    public Word2VecTrainingWriter(@ComponentSetting(value="outputFile") @NotNull String outputFile) {
        BufferedWriter bufferedWriter;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        File file = new File(outputFile);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        Word2VecTrainingWriter word2VecTrainingWriter = this;
        int n = 8192;
        Object object2 = object = file;
        object2 = new FileOutputStream((File)object2);
        object = new OutputStreamWriter((OutputStream)object2, charset2);
        word2VecTrainingWriter.outputWriter = bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
    }
}

