/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.utilities;

import edu.umn.biomedicus.sentences.Sentence;
import edu.umn.biomedicus.utilities.PtbReader;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.Labeler;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MipacqParseTagger
implements DocumentTask {
    public void run(@Nonnull Document document) {
        String sourcePath = (String)document.getMetadata().get("path");
        if (sourcePath == null) {
            throw new RuntimeException("Path not stored on document");
        }
        String text = document.getText();
        Labeler sentenceLabeler = document.labeler(Sentence.class);
        Path path = Paths.get(sourcePath.replaceFirst(".source$", ".parse"), new String[0]);
        try {
            Optional<PtbReader.Node> optional;
            PtbReader reader = PtbReader.createFromFile(path);
            int current = 0;
            while ((optional = reader.nextNode()).isPresent()) {
                int start = -1;
                PtbReader.Node node = optional.get();
                Iterator<PtbReader.Node> leafIterator = node.leafIterator();
                while (leafIterator.hasNext()) {
                    PtbReader.Node leaf = leafIterator.next();
                    String word = leaf.leafGetWord();
                    while (current < text.length() && Character.isWhitespace(text.charAt(current))) {
                        ++current;
                    }
                    int index = text.indexOf(word, current);
                    if (index != current) continue;
                    if (start == -1) {
                        start = index;
                    }
                    current = index + word.length();
                }
                if (start == -1 || start == current) continue;
                sentenceLabeler.add((Label)new Sentence(start, current));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

