/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.utilities;

import com.google.inject.Inject;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.ArtifactSource;
import edu.umn.nlpengine.StandardArtifact;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Spliterator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class MipacqSourceReader
implements ArtifactSource {
    private final long total;
    private final Spliterator<Path> iterator;
    private final String documentName;

    @Inject
    public MipacqSourceReader(@ComponentSetting(value="inputDirectory.asPath") Path inputDirectory, @ComponentSetting(value="documentName") String documentName) throws IOException {
        this.documentName = documentName;
        Predicate<Path> endsWithSource = f -> f.toString().endsWith(".source");
        this.total = Files.walk(inputDirectory, new FileVisitOption[0]).filter(endsWithSource).count();
        this.iterator = Files.walk(inputDirectory, new FileVisitOption[0]).filter(endsWithSource).spliterator();
    }

    public long estimateTotal() {
        return this.total;
    }

    public void close() {
    }

    public boolean tryAdvance(@Nonnull Function1<? super Artifact, Unit> consumer) {
        return this.iterator.tryAdvance((? super T next) -> {
            StringBuilder sb = new StringBuilder();
            try {
                Files.lines(next, StandardCharsets.UTF_8).forEach(line -> {
                    if (!line.startsWith("[")) {
                        sb.append((String)line).append("\n");
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            StandardArtifact artifact = new StandardArtifact(next.getFileName().toString());
            artifact.getMetadata().put("path", next.toString());
            artifact.addDocument(this.documentName, sb.toString());
            consumer.invoke((Object)artifact);
        });
    }
}

