/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.utilities;

import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.framework.SearchExpr;
import edu.umn.biomedicus.framework.SearchExprFactory;
import edu.umn.biomedicus.framework.Searcher;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.Span;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class SearcherPrinter
implements DocumentTask {
    private final SearchExpr searchExpr;

    @Inject
    public SearcherPrinter(SearchExprFactory searchExprFactory, @ComponentSetting(value="searchPattern") String searchPattern) {
        this.searchExpr = searchExprFactory.parse(searchPattern);
    }

    public void run(@Nonnull Document document) {
        boolean found;
        Searcher searcher = this.searchExpr.createSearcher(document);
        while (found = searcher.search()) {
            System.out.println("Matching Text: " + searcher.getSpan().get().coveredString(document.getText()));
            for (String group : searcher.getGroupNames()) {
                Label label;
                System.out.println("\tGroup Name: " + group);
                Span span = searcher.getSpan(group);
                if (span != null) {
                    System.out.println("\t\tCovered Text: " + span.coveredString(document.getText()));
                }
                if ((label = searcher.getLabel(group)) == null) continue;
                System.out.println("\t\tStored Label: " + label.toString());
            }
        }
    }
}

