/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.vocabulary;

import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.framework.LifecycleManaged;
import edu.umn.biomedicus.vocabulary.Vocabulary;
import edu.umn.biomedicus.vocabulary.VocabularyStore;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

class DefaultVocabulary
implements LifecycleManaged,
Vocabulary {
    private final VocabularyStore store;
    private final BidirectionalDictionary wordsIndex;
    private final BidirectionalDictionary bidirectionalDictionary;
    private final BidirectionalDictionary normsIndex;

    DefaultVocabulary(VocabularyStore store) {
        this.store = store;
        this.wordsIndex = store.getWords();
        this.bidirectionalDictionary = store.getTerms();
        this.normsIndex = store.getNorms();
    }

    @Override
    public BidirectionalDictionary getWordsIndex() {
        return this.wordsIndex;
    }

    @Override
    public BidirectionalDictionary getTermsIndex() {
        return this.bidirectionalDictionary;
    }

    @Override
    public BidirectionalDictionary getNormsIndex() {
        return this.normsIndex;
    }

    @Override
    public void doShutdown() throws BiomedicusException {
        try {
            this.store.close();
        }
        catch (IOException e) {
            throw new BiomedicusException(e);
        }
    }

    @Singleton
    public static class Loader
    extends DataLoader<Vocabulary> {
        private final VocabularyStore store;

        @Inject
        Loader(VocabularyStore store) {
            this.store = store;
        }

        @Override
        protected Vocabulary loadModel() throws BiomedicusException {
            try {
                this.store.open();
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
            return new DefaultVocabulary(this.store);
        }
    }
}

