/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.vocabulary;

import com.google.inject.Inject;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.WordIndex;
import edu.umn.biomedicus.vocabulary.Vocabulary;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LabelWordIndexes
implements DocumentTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelWordIndexes.class);
    private final BidirectionalDictionary wordIndex;

    @Inject
    public LabelWordIndexes(Vocabulary vocabulary) {
        this.wordIndex = vocabulary.getWordsIndex();
    }

    public void run(@Nonnull Document document) {
        LOGGER.debug("Labeling word term index identifiers in a document.");
        LabelIndex parseTokenLabelIndex = document.labelIndex(ParseToken.class);
        Labeler wordIndexLabeler = document.labeler(WordIndex.class);
        for (ParseToken parseToken : parseTokenLabelIndex) {
            String lowercase = parseToken.getText().toLowerCase(Locale.ENGLISH);
            StringIdentifier termIdentifier = this.wordIndex.getTermIdentifier(lowercase);
            wordIndexLabeler.add((Label)new WordIndex(parseToken, termIdentifier));
        }
    }
}

