/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.vocabulary;

import com.google.common.base.Preconditions;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.RocksDbIdentifiers;
import edu.umn.biomedicus.common.dictionary.RocksDbStrings;
import edu.umn.biomedicus.common.dictionary.StandardBidirectionalDictionary;
import edu.umn.biomedicus.vocabulary.VocabularyStore;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RocksDbVocabStore
extends VocabularyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDbVocabStore.class);
    private final Path dbPath;
    private final Boolean inMemory;
    @Nullable
    private BidirectionalDictionary words;
    @Nullable
    private BidirectionalDictionary terms;
    @Nullable
    private BidirectionalDictionary norms;

    @Inject
    public RocksDbVocabStore(@Setting(value="vocabulary.db.asDataPath") Path dbPath, @Setting(value="vocabulary.inMemory") Boolean inMemory) {
        this.dbPath = dbPath;
        this.inMemory = inMemory;
    }

    @Override
    void open() {
        LOGGER.info("Loading vocabularies: {}", (Object)this.dbPath);
        LOGGER.info("Opening words index. inMemory = {}.", (Object)this.inMemory);
        RocksDbStrings wordsTerms = new RocksDbStrings(this.dbPath.resolve("wordsTerms"));
        RocksDbIdentifiers wordsIndices = new RocksDbIdentifiers(this.dbPath.resolve("wordsIndices"));
        this.words = new StandardBidirectionalDictionary(wordsIndices, wordsTerms).inMemory(this.inMemory);
        LOGGER.info("Opening terms index. inMemory = {}.", (Object)this.inMemory);
        RocksDbStrings termsTerms = new RocksDbStrings(this.dbPath.resolve("termsTerms"));
        RocksDbIdentifiers termsIndices = new RocksDbIdentifiers(this.dbPath.resolve("termsIndices"));
        this.terms = new StandardBidirectionalDictionary(termsIndices, termsTerms).inMemory(this.inMemory);
        LOGGER.info("Opening norms index. inMemory = {}.", (Object)this.inMemory);
        RocksDbStrings normsTerms = new RocksDbStrings(this.dbPath.resolve("normsTerms"));
        RocksDbIdentifiers normsIndices = new RocksDbIdentifiers(this.dbPath.resolve("normsIndices"));
        this.norms = new StandardBidirectionalDictionary(normsIndices, normsTerms).inMemory(this.inMemory);
    }

    @Override
    BidirectionalDictionary getWords() {
        Preconditions.checkNotNull((Object)this.words);
        return this.words;
    }

    @Override
    BidirectionalDictionary getTerms() {
        Preconditions.checkNotNull((Object)this.terms);
        return this.terms;
    }

    @Override
    BidirectionalDictionary getNorms() {
        Preconditions.checkNotNull((Object)this.norms);
        return this.norms;
    }

    @Override
    public void close() throws IOException {
        if (this.words != null) {
            this.words.close();
            this.words = null;
        }
        if (this.terms != null) {
            this.terms.close();
            this.terms = null;
        }
        if (this.norms != null) {
            this.norms.close();
            this.norms = null;
        }
    }
}

