/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.vocabulary;

import edu.umn.biomedicus.common.utilities.Patterns;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.vocabulary.TermIndexBuilder;
import edu.umn.biomedicus.vocabulary.VocabularyBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

@Singleton
public class RocksDbVocabularyBuilder
extends VocabularyBuilder {
    private static final Pattern MORE_THAN_TWO_NUMBERS_IN_A_ROW = Pattern.compile("[\\p{Nd}]{3,}");
    private RocksDbTermIndexBuilder words;
    private RocksDbTermIndexBuilder terms;
    private RocksDbTermIndexBuilder norms;

    @Override
    void setOutputPath(Path outputPath) {
        try {
            Files.createDirectories(outputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();){
            try {
                this.words = new RocksDbTermIndexBuilder(RocksDB.open((Options)options, (String)outputPath.resolve("wordsTerms").toString()), RocksDB.open((Options)options, (String)outputPath.resolve("wordsIndices").toString()));
                this.terms = new RocksDbTermIndexBuilder(RocksDB.open((Options)options, (String)outputPath.resolve("termsTerms").toString()), RocksDB.open((Options)options, (String)outputPath.resolve("termsIndices").toString()));
                this.norms = new RocksDbTermIndexBuilder(RocksDB.open((Options)options, (String)outputPath.resolve("normsTerms").toString()), RocksDB.open((Options)options, (String)outputPath.resolve("normsIndices").toString()));
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    TermIndexBuilder createWordsIndexBuilder() {
        return this.words;
    }

    @Override
    TermIndexBuilder createTermsIndexBuilder() {
        return this.terms;
    }

    @Override
    TermIndexBuilder createNormsIndexBuilder() {
        return this.norms;
    }

    @Override
    public void doShutdown() throws BiomedicusException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            if (this.words != null) {
                this.words.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            if (this.terms != null) {
                this.terms.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        try {
            if (this.norms != null) {
                this.norms.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (exceptions.size() > 0) {
            BiomedicusException exception = new BiomedicusException("Failed to close RocksDB builders.", new String[0]);
            exceptions.forEach(exception::addSuppressed);
            throw exception;
        }
    }

    private static class RocksDbTermIndexBuilder
    implements TermIndexBuilder,
    Closeable {
        private final TreeSet<String> termSet = new TreeSet();
        private final RocksDB terms;
        private final RocksDB indices;

        public RocksDbTermIndexBuilder(RocksDB terms, RocksDB indices) {
            this.terms = terms;
            this.indices = indices;
        }

        @Override
        public void addTerm(String term) {
            if (MORE_THAN_TWO_NUMBERS_IN_A_ROW.matcher(term).find()) {
                return;
            }
            if (!this.termSet.contains(term) && Patterns.A_LETTER_OR_NUMBER.matcher(term).find()) {
                this.termSet.add(term);
            }
        }

        @Override
        public void doWrite() {
            int i = 0;
            for (String s : this.termSet) {
                byte[] termBytes = s.getBytes(StandardCharsets.UTF_8);
                byte[] indexBytes = ByteBuffer.allocate(4).putInt(i).array();
                try {
                    this.terms.put(indexBytes, termBytes);
                    this.indices.put(termBytes, indexBytes);
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
                i = Math.incrementExact(i);
            }
        }

        @Override
        public void close() {
            this.terms.close();
            this.indices.close();
        }
    }
}

