/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.vocabulary;

import com.google.inject.Inject;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.framework.SearchExpr;
import edu.umn.biomedicus.framework.SearchExprFactory;
import edu.umn.biomedicus.vocabulary.Vocabulary;
import edu.umn.nlpengine.Span;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VocabularySearchExprFactory {
    private static final Pattern WORD_REPLACE = Pattern.compile("\\$words\"([\\p{all}&&[^\"]]*)\"");
    private static final Pattern TERM_REPLACE = Pattern.compile("\\$terms\"([\\p{all}&&[^\"]]*)\"");
    private static final Pattern NORM_REPLACE = Pattern.compile("\\$norms\"([\\p{all}&&[^\"]]*)\"");
    private final SearchExprFactory searchExprFactory;
    private final BidirectionalDictionary wordsIndex;
    private final BidirectionalDictionary termsIndex;
    private final BidirectionalDictionary normsIndex;

    @Inject
    public VocabularySearchExprFactory(Vocabulary vocabulary, SearchExprFactory searchExprFactory) {
        this.wordsIndex = vocabulary.getWordsIndex();
        this.termsIndex = vocabulary.getTermsIndex();
        this.normsIndex = vocabulary.getNormsIndex();
        this.searchExprFactory = searchExprFactory;
    }

    public SearchExpr parseExpression(String expression) {
        TreeMap<Span, String> replacements = new TreeMap<Span, String>();
        this.findReplacements(replacements, WORD_REPLACE.matcher(expression), this.wordsIndex);
        this.findReplacements(replacements, TERM_REPLACE.matcher(expression), this.termsIndex);
        this.findReplacements(replacements, NORM_REPLACE.matcher(expression), this.normsIndex);
        if (replacements.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(expression);
            for (Map.Entry entry : replacements.descendingMap().entrySet()) {
                stringBuilder.replace(((Span)entry.getKey()).getStartIndex(), ((Span)entry.getKey()).getEndIndex(), (String)entry.getValue());
            }
            expression = stringBuilder.toString();
        }
        return this.searchExprFactory.parse(expression);
    }

    private void findReplacements(Map<Span, String> replacements, Matcher matcher, BidirectionalDictionary dictionary) {
        while (matcher.find()) {
            String word = matcher.group(1);
            StringIdentifier termIdentifier = dictionary.getTermIdentifier(word);
            if (termIdentifier.isUnknown()) {
                throw new IllegalArgumentException("Unknown string: " + word);
            }
            replacements.put(new Span(matcher.start(), matcher.end()), "" + termIdentifier.value());
        }
    }
}

