/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.adapter;

import com.google.common.base.Preconditions;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.uima.adapter.CASArtifact;
import edu.umn.biomedicus.uima.adapter.GuiceInjector;
import edu.umn.biomedicus.uima.labels.LabelAdapters;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCasAdapter
extends CasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCasAdapter.class);
    @Nullable
    private LabelAdapters labelAdapters;
    @Nullable
    private GuiceInjector guiceInjector;
    private Map<String, Object> settingsMap;
    private Collection<String> requiredClassNames;

    protected GuiceInjector getGuiceInjector() {
        return (GuiceInjector)((Object)Preconditions.checkNotNull((Object)((Object)this.guiceInjector)));
    }

    protected Map<String, Object> getSettingsMap() {
        return (Map)Preconditions.checkNotNull(this.settingsMap);
    }

    protected Collection<String> getRequiredClassNames() {
        return (Collection)Preconditions.checkNotNull(this.requiredClassNames);
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.guiceInjector = (GuiceInjector)((Object)aContext.getResourceObject("guiceInjector"));
            this.labelAdapters = (LabelAdapters)this.guiceInjector.attach().getInstance(LabelAdapters.class);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.settingsMap = new HashMap<String, Object>();
        for (String parameterName : aContext.getConfigParameterNames()) {
            if (parameterName == null) continue;
            this.settingsMap.put(parameterName, aContext.getConfigParameterValue(parameterName));
        }
    }

    public final void process(CAS aCAS) throws AnalysisEngineProcessException {
        CASArtifact casArtifact = new CASArtifact(this.labelAdapters, aCAS);
        try {
            this.process(casArtifact);
        }
        catch (BiomedicusException e) {
            LOGGER.error("error while processing document: " + casArtifact.getArtifactID());
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected abstract void process(CASArtifact var1) throws BiomedicusException;

    public void destroy() {
        try {
            this.guiceInjector.detach();
        }
        catch (BiomedicusException e) {
            LOGGER.error("Failed to detach from guice injector", (Throwable)e);
        }
    }
}

