/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.adapter;

import com.google.common.base.Preconditions;
import edu.umn.biomedicus.uima.labels.LabelAdapter;
import edu.umn.biomedicus.uima.labels.LabelAdapterFactory;
import edu.umn.biomedicus.uima.labels.LabelAdapters;
import edu.umn.biomedicus.uima.labels.UimaLabelIndex;
import edu.umn.biomedicus.uima.labels.UimaLabeler;
import edu.umn.nlpengine.AbstractArtifact;
import edu.umn.nlpengine.AbstractDocument;
import edu.umn.nlpengine.Artifact;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;

public final class CASArtifact
extends AbstractArtifact {
    @Nullable
    private final LabelAdapters labelAdapters;
    private final CAS cas;
    private final CAS metadataCas;
    private final Type metadataType;
    private final Feature keyFeature;
    private final Feature valueFeature;
    private final String artifactID;
    private final FSIndex<FeatureStructure> metadataIndex;
    private final CASMetadata casMetadata;

    CASArtifact(@Nullable LabelAdapters labelAdapters, CAS cas) {
        this.labelAdapters = labelAdapters;
        this.cas = cas;
        TypeSystem typeSystem = cas.getTypeSystem();
        this.metadataType = typeSystem.getType("ArtifactMetadata");
        this.keyFeature = this.metadataType.getFeatureByBaseName("key");
        this.valueFeature = this.metadataType.getFeatureByBaseName("value");
        this.metadataCas = cas.getView("metadata");
        Type idType = typeSystem.getType("ArtifactID");
        Feature idFeat = idType.getFeatureByBaseName("artifactID");
        FSIndexRepository indexRepository = this.metadataCas.getIndexRepository();
        this.artifactID = indexRepository.getIndex("artifactID", idType).iterator().get().getStringValue(idFeat);
        this.metadataIndex = indexRepository.getIndex("metadata", this.metadataType);
        this.casMetadata = new CASMetadata();
    }

    CASArtifact(@Nullable LabelAdapters labelAdapters, CAS cas, String artifactID) {
        this.labelAdapters = labelAdapters;
        this.cas = cas;
        TypeSystem typeSystem = cas.getTypeSystem();
        this.metadataType = typeSystem.getType("ArtifactMetadata");
        this.keyFeature = this.metadataType.getFeatureByBaseName("key");
        this.valueFeature = this.metadataType.getFeatureByBaseName("value");
        this.metadataCas = cas.createView("metadata");
        this.metadataCas.setDocumentText("");
        Type idType = typeSystem.getType("ArtifactID");
        Feature idFeat = idType.getFeatureByBaseName("artifactID");
        this.artifactID = artifactID;
        FeatureStructure documentIdFs = this.metadataCas.createFS(idType);
        documentIdFs.setStringValue(idFeat, artifactID);
        this.metadataCas.addFsToIndexes(documentIdFs);
        this.metadataIndex = this.metadataCas.getIndexRepository().getIndex("metadata", this.metadataType);
        this.casMetadata = new CASMetadata();
    }

    CASArtifact(@Nullable LabelAdapters labelAdapters, Artifact artifact, CAS cas) {
        this.labelAdapters = labelAdapters;
        this.cas = cas;
        TypeSystem typeSystem = cas.getTypeSystem();
        this.metadataType = typeSystem.getType("ArtifactMetadata");
        this.keyFeature = this.metadataType.getFeatureByBaseName("key");
        this.valueFeature = this.metadataType.getFeatureByBaseName("value");
        this.metadataCas = cas.createView("metadata");
        this.metadataCas.setDocumentText("");
        Type idType = typeSystem.getType("ArtifactID");
        Feature idFeat = idType.getFeatureByBaseName("artifactID");
        this.artifactID = artifact.getArtifactID();
        FeatureStructure documentIdFs = this.metadataCas.createFS(idType);
        documentIdFs.setStringValue(idFeat, this.artifactID);
        this.metadataCas.addFsToIndexes(documentIdFs);
        this.metadataIndex = this.metadataCas.getIndexRepository().getIndex("metadata", this.metadataType);
        this.casMetadata = new CASMetadata();
        this.casMetadata.putAll(artifact.getMetadata());
        this.copyDocuments(artifact);
    }

    public static CASArtifact open(@Nullable LabelAdapters labelAdapters, CAS top) {
        return new CASArtifact(labelAdapters, top);
    }

    public static CASArtifact initialize(@Nullable LabelAdapters labelAdapters, CAS top, String documentId) {
        return new CASArtifact(labelAdapters, top, documentId);
    }

    @Nonnull
    public String getArtifactID() {
        return this.artifactID;
    }

    @Nonnull
    public Map<String, String> getMetadata() {
        return this.casMetadata;
    }

    public CAS getCas() {
        return this.cas;
    }

    @Nonnull
    public Map<String, Document> getDocuments() {
        return new AbstractMap<String, Document>(){

            @Override
            @Nonnull
            public Set<Map.Entry<String, Document>> entrySet() {
                return new AbstractSet<Map.Entry<String, Document>>(){

                    @Override
                    @Nonnull
                    public Iterator<Map.Entry<String, Document>> iterator() {
                        final Iterator viewIterator = CASArtifact.this.cas.getViewIterator();
                        return new Iterator<Map.Entry<String, Document>>(){
                            @Nullable
                            CAS nextCas;
                            {
                                this.advance();
                            }

                            void advance() {
                                if (!viewIterator.hasNext()) {
                                    this.nextCas = null;
                                    return;
                                }
                                CAS next = (CAS)viewIterator.next();
                                if (!next.getViewName().equals("metadata") && !next.getViewName().equals("_InitialView")) {
                                    this.nextCas = next;
                                } else {
                                    this.advance();
                                }
                            }

                            @Override
                            public boolean hasNext() {
                                return this.nextCas != null;
                            }

                            @Override
                            public Map.Entry<String, Document> next() {
                                if (this.nextCas == null) {
                                    throw new NoSuchElementException();
                                }
                                CAS value = this.nextCas;
                                this.advance();
                                return new AbstractMap.SimpleImmutableEntry<String, CASDocument>(value.getViewName(), new CASDocument(value, CASArtifact.this.labelAdapters));
                            }
                        };
                    }

                    @Override
                    public int size() {
                        int count = 0;
                        Iterator viewIterator = CASArtifact.this.cas.getViewIterator();
                        while (viewIterator.hasNext()) {
                            ++count;
                            viewIterator.next();
                        }
                        return count;
                    }
                };
            }
        };
    }

    @Nonnull
    public Document addDocument(@Nonnull String name, @Nonnull String text) {
        CAS view = this.cas.createView(name);
        view.setDocumentText(text);
        return new CASDocument(view, this.labelAdapters);
    }

    private class CASDocument
    extends AbstractDocument {
        private final CAS view;
        @Nullable
        private final LabelAdapters labelAdapters;
        private final Map<Class<?>, LabelIndex<?>> labelIndices;

        CASDocument(@Nullable CAS view, LabelAdapters labelAdapters) {
            super(view.getViewName(), view.getDocumentText());
            this.labelIndices = new HashMap();
            this.view = view;
            this.labelAdapters = labelAdapters;
        }

        @Nonnull
        public <T extends Label> LabelIndex<T> labelIndex(@Nonnull Class<T> labelClass) {
            Preconditions.checkNotNull((Object)this.labelAdapters);
            Object labelIndex = this.labelIndices.get(labelClass);
            if (labelIndex == null) {
                LabelAdapter<T> labelAdapter = this.labelAdapters.getLabelAdapterFactory(labelClass).create(this.view, (Document)this);
                labelIndex = new UimaLabelIndex<T>(this.view, labelAdapter);
                this.labelIndices.put(labelClass, (LabelIndex<?>)labelIndex);
            }
            return labelIndex;
        }

        @Nonnull
        public <T extends Label> Labeler<T> labeler(@Nonnull Class<T> labelClass) {
            Preconditions.checkNotNull((Object)this.labelAdapters);
            LabelAdapter<T> labelAdapter = this.labelAdapters.getLabelAdapterFactory(labelClass).create(this.view, (Document)this);
            return new UimaLabeler<T>(labelAdapter, (Document)this);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CASDocument that = (CASDocument)((Object)o);
            return this.view.equals(that.view);
        }

        public int hashCode() {
            return this.view.hashCode();
        }

        @Nonnull
        public String getArtifactID() {
            return CASArtifact.this.artifactID;
        }

        @Nonnull
        public Map<String, String> getMetadata() {
            return CASArtifact.this.casMetadata;
        }

        @Nonnull
        public Collection<LabelIndex<?>> labelIndexes() {
            return new AbstractCollection<LabelIndex<?>>(){

                @Override
                @Nonnull
                public Iterator<LabelIndex<?>> iterator() {
                    final Iterator indexes = CASDocument.this.view.getIndexRepository().getIndexes();
                    return new Iterator<LabelIndex<?>>(){
                        boolean hasNext;
                        LabelIndex<?> next;
                        {
                            this.tryAdvance();
                        }

                        void tryAdvance() {
                            if (CASDocument.this.labelAdapters == null) {
                                throw new IllegalStateException("Attempting to iterate a cas document with label adapters");
                            }
                            FSIndex index = (FSIndex)indexes.next();
                            if (this.next == null) {
                                this.hasNext = false;
                            }
                            Type type = index.getType();
                            LabelAdapterFactory<?> factory = CASDocument.this.labelAdapters.getLabelAdapterFactory(type);
                            this.hasNext = true;
                            this.next = new UimaLabelIndex(CASArtifact.this.cas, factory.create(CASArtifact.this.cas, (Document)CASDocument.this));
                        }

                        @Override
                        public boolean hasNext() {
                            return this.hasNext;
                        }

                        @Override
                        public LabelIndex<?> next() {
                            if (!this.hasNext) {
                                throw new NoSuchElementException("No next label index.");
                            }
                            LabelIndex<?> index = this.next;
                            this.tryAdvance();
                            return index;
                        }
                    };
                }

                @Override
                public int size() {
                    int size2 = 0;
                    for (LabelIndex<?> ignored : this) {
                        ++size2;
                    }
                    return size2;
                }
            };
        }
    }

    private class CASMetadata
    extends AbstractMap<String, String> {
        private CASMetadata() {
        }

        @Override
        @Nonnull
        public Set<Map.Entry<String, String>> entrySet() {
            return new AbstractSet<Map.Entry<String, String>>(){

                @Override
                @Nonnull
                public Iterator<Map.Entry<String, String>> iterator() {
                    final FSIterator it = CASArtifact.this.metadataIndex.iterator();
                    return new Iterator<Map.Entry<String, String>>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<String, String> next() {
                            FeatureStructure next = (FeatureStructure)it.next();
                            return new AbstractMap.SimpleImmutableEntry<String, String>(next.getStringValue(CASArtifact.this.keyFeature), next.getStringValue(CASArtifact.this.valueFeature));
                        }
                    };
                }

                @Override
                public int size() {
                    return CASArtifact.this.metadataIndex.size();
                }
            };
        }

        @Override
        @Nullable
        public String get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            FeatureStructure check = CASArtifact.this.metadataCas.createFS(CASArtifact.this.metadataType);
            check.setStringValue(CASArtifact.this.keyFeature, (String)key);
            FeatureStructure fs = CASArtifact.this.metadataIndex.find(check);
            return fs.getStringValue(CASArtifact.this.valueFeature);
        }

        @Override
        @Nullable
        public String put(String key, String value) {
            FeatureStructure check = CASArtifact.this.metadataCas.createFS(CASArtifact.this.metadataType);
            check.setStringValue(CASArtifact.this.keyFeature, key);
            FeatureStructure fs = CASArtifact.this.metadataIndex.find(check);
            String existing = null;
            if (fs != null) {
                existing = fs.getStringValue(CASArtifact.this.valueFeature);
                CASArtifact.this.metadataCas.removeFsFromIndexes(fs);
            } else {
                fs = check;
            }
            fs.setStringValue(CASArtifact.this.valueFeature, value);
            CASArtifact.this.metadataCas.addFsToIndexes(fs);
            return existing;
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            FeatureStructure check = CASArtifact.this.metadataCas.createFS(CASArtifact.this.metadataType);
            check.setStringValue(CASArtifact.this.keyFeature, (String)key);
            return CASArtifact.this.metadataIndex.contains(check);
        }
    }
}

