/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.adapter;

import com.google.inject.Injector;
import com.google.inject.Module;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.Application;
import edu.umn.biomedicus.framework.Bootstrapper;
import edu.umn.biomedicus.framework.LifecycleManager;
import edu.umn.biomedicus.uima.labels.AutoAdapters;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.uima.analysis_engine.metadata.impl.AnalysisEngineMetaData_impl;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiceInjector
extends Resource_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceInjector.class);
    private final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);
    private Injector injector;
    private LifecycleManager lifecycleManager;

    public GuiceInjector() {
        LOGGER.info("Initializing Guice Injector Resource");
        try {
            Application application = Bootstrapper.create((Module[])new Module[0]);
            this.injector = application.getInjector();
            this.lifecycleManager = (LifecycleManager)this.injector.getInstance(LifecycleManager.class);
        }
        catch (BiomedicusException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (!super.initialize(aSpecifier, aAdditionalParams)) {
            return false;
        }
        TypeSystemDescription_impl typeSystem = new TypeSystemDescription_impl();
        AutoAdapters adapters = (AutoAdapters)this.injector.getInstance(AutoAdapters.class);
        adapters.addToTypeSystem((TypeSystemDescription)typeSystem);
        AnalysisEngineMetaData_impl md = new AnalysisEngineMetaData_impl();
        md.setTypeSystem((TypeSystemDescription)typeSystem);
        this.getCasManager().addMetaData((ProcessingResourceMetaData)md);
        return true;
    }

    public Injector attach() {
        if (!this.semaphore.tryAcquire(1)) {
            throw new IllegalStateException("Somehow attached Integer.MAX_VALUE things to Guice resource");
        }
        return this.injector;
    }

    public void detach() throws BiomedicusException {
        this.semaphore.release(1);
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE)) {
            this.injector = null;
            this.lifecycleManager.triggerShutdown();
        }
    }
}

