/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import edu.umn.biomedicus.uima.copying.FeatureCopier;
import edu.umn.biomedicus.uima.copying.FeatureGetter;
import edu.umn.biomedicus.uima.copying.FeatureSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.TypeSystem;

class FeatureCopiers {
    private static final Map<String, FeatureCopier> FEATURE_COPIERS;
    private static final FeatureCopier STRING_COPIER;
    private final UnaryOperator<FeatureStructure> fsEncounteredCallback;

    FeatureCopiers(UnaryOperator<FeatureStructure> fsEncounteredCallback) {
        this.fsEncounteredCallback = Objects.requireNonNull(fsEncounteredCallback);
    }

    private static <T> FeatureCopier primitiveFeatureCopier(FeatureGetter<T> featureGetter, FeatureSetter<T> featureSetter) {
        return (fromFeature, fromFs, toFs) -> {
            Object value = featureGetter.get(fromFs, fromFeature);
            Feature toFeature = toFs.getType().getFeatureByBaseName(fromFeature.getShortName());
            featureSetter.set(toFs, toFeature, value);
        };
    }

    private void defaultFeatureMapper(Feature fromFeature, FeatureStructure fromFs, FeatureStructure toFs) {
        TypeSystem typeSystem = fromFs.getCAS().getTypeSystem();
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), fromFeature.getRange())) {
            STRING_COPIER.copy(fromFeature, fromFs, toFs);
        } else {
            FeatureStructure fromFeatureValue = fromFs.getFeatureValue(fromFeature);
            if (fromFeatureValue != null) {
                FeatureStructure toFeatureValue = (FeatureStructure)this.fsEncounteredCallback.apply(fromFeatureValue);
                Feature toFeature = toFs.getType().getFeatureByBaseName(fromFeature.getShortName());
                toFs.setFeatureValue(toFeature, toFeatureValue);
            }
        }
    }

    public void copyFeature(Feature fromFeature, FeatureStructure fromFs, FeatureStructure toFs) {
        String featureTypeName = fromFeature.getRange().getName();
        FEATURE_COPIERS.getOrDefault(featureTypeName, this::defaultFeatureMapper).copy(fromFeature, fromFs, toFs);
    }

    static {
        STRING_COPIER = FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getStringValue, FeatureStructure::setStringValue);
        HashMap<String, FeatureCopier> featureCopiersBuilder = new HashMap<String, FeatureCopier>();
        featureCopiersBuilder.put("uima.cas.Boolean", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getBooleanValue, FeatureStructure::setBooleanValue));
        featureCopiersBuilder.put("uima.cas.Byte", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getByteValue, FeatureStructure::setByteValue));
        featureCopiersBuilder.put("uima.cas.Double", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getDoubleValue, FeatureStructure::setDoubleValue));
        featureCopiersBuilder.put("uima.cas.Float", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getFloatValue, FeatureStructure::setFloatValue));
        featureCopiersBuilder.put("uima.cas.Integer", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getIntValue, FeatureStructure::setIntValue));
        featureCopiersBuilder.put("uima.cas.Long", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getLongValue, FeatureStructure::setLongValue));
        featureCopiersBuilder.put("uima.cas.Short", FeatureCopiers.primitiveFeatureCopier(FeatureStructure::getShortValue, FeatureStructure::setShortValue));
        featureCopiersBuilder.put("uima.cas.String", STRING_COPIER);
        FEATURE_COPIERS = Collections.unmodifiableMap(featureCopiersBuilder);
    }
}

