/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import edu.umn.biomedicus.uima.copying.FsConstructors;
import edu.umn.biomedicus.uima.copying.FsCopiers;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;

class FeatureStructureCopyingQueue {
    private final FsCopiers fsCopiers;
    private final FsConstructors fsConstructors;
    private final Deque<FeatureStructure> fsQueue;
    private final Map<FeatureStructure, FeatureStructure> fsMap;

    FeatureStructureCopyingQueue(FsCopiers fsCopiers, FsConstructors fsConstructors, Deque<FeatureStructure> fsQueue, Map<FeatureStructure, FeatureStructure> fsMap) {
        this.fsCopiers = fsCopiers;
        this.fsConstructors = fsConstructors;
        this.fsQueue = fsQueue;
        this.fsMap = fsMap;
    }

    FeatureStructureCopyingQueue(CAS sourceView, CAS destinationView) {
        this.fsCopiers = new FsCopiers(this::enqueue);
        this.fsConstructors = new FsConstructors(destinationView);
        this.fsQueue = new ArrayDeque<FeatureStructure>();
        this.fsMap = new HashMap<FeatureStructure, FeatureStructure>();
        this.fsMap.put((FeatureStructure)sourceView.getSofa(), (FeatureStructure)destinationView.getSofa());
    }

    FeatureStructure enqueue(FeatureStructure featureStructure) {
        Objects.requireNonNull(featureStructure);
        if (this.fsMap.containsKey(featureStructure)) {
            return this.fsMap.get(featureStructure);
        }
        this.fsQueue.add(featureStructure);
        FeatureStructure targetFs = this.fsConstructors.createNewInstanceOfSameType(featureStructure);
        this.fsMap.put(featureStructure, targetFs);
        return targetFs;
    }

    void run() {
        while (!this.fsQueue.isEmpty()) {
            FeatureStructure from = this.fsQueue.poll();
            FeatureStructure to = this.fsMap.get(from);
            this.fsCopiers.copy(from, to);
        }
    }
}

