/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;

class FsConstructors {
    private final CAS targetCas;
    private final Map<String, UnaryOperator<FeatureStructure>> constructors;

    FsConstructors(CAS targetCas) {
        this.targetCas = targetCas;
        this.constructors = new HashMap<String, UnaryOperator<FeatureStructure>>();
        this.constructors.put("uima.cas.BooleanArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createBooleanArrayFS(arg_0)));
        this.constructors.put("uima.cas.ByteArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createByteArrayFS(arg_0)));
        this.constructors.put("uima.cas.DoubleArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createDoubleArrayFS(arg_0)));
        this.constructors.put("uima.cas.FloatArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createFloatArrayFS(arg_0)));
        this.constructors.put("uima.cas.FSArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createArrayFS(arg_0)));
        this.constructors.put("uima.cas.LongArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createLongArrayFS(arg_0)));
        this.constructors.put("uima.cas.IntegerArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createIntArrayFS(arg_0)));
        this.constructors.put("uima.cas.ShortArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createShortArrayFS(arg_0)));
        this.constructors.put("uima.cas.StringArray", this.arrayFactory(arg_0 -> ((CAS)targetCas).createStringArrayFS(arg_0)));
    }

    private UnaryOperator<FeatureStructure> arrayFactory(Function<Integer, FeatureStructure> constructor) {
        return featureStructure -> (FeatureStructure)constructor.apply(((CommonArrayFS)featureStructure).size());
    }

    private FeatureStructure defaultCreateType(FeatureStructure featureStructure) {
        String typeName = featureStructure.getType().getName();
        Type targetType = this.targetCas.getTypeSystem().getType(typeName);
        return this.targetCas.createFS(targetType);
    }

    public FeatureStructure createNewInstanceOfSameType(FeatureStructure featureStructure) {
        String typeName = featureStructure.getType().getName();
        return (FeatureStructure)this.constructors.getOrDefault(typeName, this::defaultCreateType).apply(featureStructure);
    }
}

