/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import edu.umn.biomedicus.uima.copying.FeatureCopiers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;

class FsCopiers {
    private final Map<String, BiConsumer<FeatureStructure, FeatureStructure>> fsCopiers;
    private final FeatureCopiers featureCopiers;
    private final UnaryOperator<FeatureStructure> featureStructureEncounteredCallback;

    FsCopiers(Map<String, BiConsumer<FeatureStructure, FeatureStructure>> fsCopiers, FeatureCopiers featureCopiers, UnaryOperator<FeatureStructure> featureStructureEncounteredCallback) {
        this.fsCopiers = fsCopiers;
        this.featureCopiers = featureCopiers;
        this.featureStructureEncounteredCallback = featureStructureEncounteredCallback;
    }

    FsCopiers(UnaryOperator<FeatureStructure> featureStructureEncounteredCallback, FeatureCopiers featureCopiers) {
        this.featureCopiers = featureCopiers;
        this.featureStructureEncounteredCallback = featureStructureEncounteredCallback;
        this.fsCopiers = new HashMap<String, BiConsumer<FeatureStructure, FeatureStructure>>();
        this.fsCopiers.put("uima.cas.BooleanArray", FsCopiers.copyArray(BooleanArrayFS.class));
        this.fsCopiers.put("uima.cas.ByteArray", FsCopiers.copyArray(ByteArrayFS.class));
        this.fsCopiers.put("uima.cas.DoubleArray", FsCopiers.copyArray(DoubleArrayFS.class));
        this.fsCopiers.put("uima.cas.FloatArray", FsCopiers.copyArray(FloatArrayFS.class));
        this.fsCopiers.put("uima.cas.FSArray", this::copyFsArray);
        this.fsCopiers.put("uima.cas.LongArray", FsCopiers.copyArray(LongArrayFS.class));
        this.fsCopiers.put("uima.cas.IntegerArray", FsCopiers.copyArray(IntArrayFS.class));
        this.fsCopiers.put("uima.cas.ShortArray", FsCopiers.copyArray(ShortArrayFS.class));
        this.fsCopiers.put("uima.cas.StringArray", FsCopiers.copyArray(StringArrayFS.class));
    }

    FsCopiers(UnaryOperator<FeatureStructure> featureStructureEncounteredCallback) {
        this.featureCopiers = new FeatureCopiers(featureStructureEncounteredCallback);
        this.featureStructureEncounteredCallback = featureStructureEncounteredCallback;
        this.fsCopiers = new HashMap<String, BiConsumer<FeatureStructure, FeatureStructure>>();
        this.fsCopiers.put("uima.cas.BooleanArray", FsCopiers.copyArray(BooleanArrayFS.class));
        this.fsCopiers.put("uima.cas.ByteArray", FsCopiers.copyArray(ByteArrayFS.class));
        this.fsCopiers.put("uima.cas.DoubleArray", FsCopiers.copyArray(DoubleArrayFS.class));
        this.fsCopiers.put("uima.cas.FloatArray", FsCopiers.copyArray(FloatArrayFS.class));
        this.fsCopiers.put("uima.cas.FSArray", this::copyFsArray);
        this.fsCopiers.put("uima.cas.LongArray", FsCopiers.copyArray(LongArrayFS.class));
        this.fsCopiers.put("uima.cas.IntegerArray", FsCopiers.copyArray(IntArrayFS.class));
        this.fsCopiers.put("uima.cas.ShortArray", FsCopiers.copyArray(ShortArrayFS.class));
        this.fsCopiers.put("uima.cas.StringArray", FsCopiers.copyArray(StringArrayFS.class));
    }

    private static BiConsumer<FeatureStructure, FeatureStructure> copyArray(Class<? extends CommonArrayFS> aClass) {
        Method fromArrayMethod;
        Method toArrayMethod;
        try {
            toArrayMethod = aClass.getMethod("toArray", new Class[0]);
            fromArrayMethod = aClass.getMethod("copyFromArray", toArrayMethod.getReturnType(), Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return (from, to) -> {
            try {
                fromArrayMethod.invoke(to, toArrayMethod.invoke(from, new Object[0]), 0, 0, ((CommonArrayFS)from).size());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private void copyFsArray(FeatureStructure from, FeatureStructure to) {
        ArrayFS sourceFses = (ArrayFS)from;
        ArrayFS targetFses = (ArrayFS)to;
        for (int index = 0; index < sourceFses.size(); ++index) {
            FeatureStructure arrayMember = sourceFses.get(index);
            FeatureStructure toFs = (FeatureStructure)this.featureStructureEncounteredCallback.apply(arrayMember);
            targetFses.set(index, toFs);
        }
    }

    private void defaultCopy(FeatureStructure from, FeatureStructure to) {
        List features = from.getType().getFeatures();
        for (Feature feature : features) {
            this.featureCopiers.copyFeature(feature, from, to);
        }
    }

    public void copy(FeatureStructure from, FeatureStructure to) {
        this.fsCopiers.getOrDefault(from.getType().getName(), this::defaultCopy).accept(from, to);
        to.getCAS().addFsToIndexes(to);
    }
}

