/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import edu.umn.biomedicus.uima.copying.FeatureStructureCopyingQueue;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;

public final class UimaCopying {
    private UimaCopying() {
        throw new UnsupportedOperationException("Instantiation of utility class");
    }

    public static void copyFeatureStructure(FeatureStructure featureStructure, CAS destinationView) {
        CAS source = featureStructure.getCAS();
        FeatureStructureCopyingQueue featureStructureCopyingQueue = new FeatureStructureCopyingQueue(source, destinationView);
        featureStructureCopyingQueue.enqueue(featureStructure);
        featureStructureCopyingQueue.run();
    }

    public static void copyFeatureStructuresOfType(String typeName, CAS sourceView, CAS destinationView) {
        FeatureStructureCopyingQueue featureStructureCopyingQueue = new FeatureStructureCopyingQueue(sourceView, destinationView);
        FSIterator iterator2 = sourceView.getIndexRepository().getAllIndexedFS(sourceView.getTypeSystem().getType(typeName));
        while (iterator2.hasNext()) {
            FeatureStructure featureStructure = iterator2.get();
            featureStructureCopyingQueue.enqueue(featureStructure);
        }
        featureStructureCopyingQueue.run();
    }

    public static void copyFeatureStructuresOfType(int type, JCas sourceView, JCas destinationView) {
        UimaCopying.copyFeatureStructuresOfType(sourceView.getType((int)type).casType.getName(), sourceView.getCas(), destinationView.getCas());
    }
}

