/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.copying;

import edu.umn.biomedicus.uima.copying.ViewCopier;
import edu.umn.biomedicus.uima.copying.ViewMigrator;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class ViewMigratorJCasMultiplier
extends JCasMultiplier_ImplBase {
    public static final String PARAM_SOURCE_VIEW_NAME = "sourceViewName";
    public static final String PARAM_TARGET_VIEW_NAME = "targetViewName";
    public static final String PARAM_DELETE_ORIGINAL_VIEW = "deleteOriginalView";
    public static final String PARAM_VIEW_MIGRATOR_CLASS = "viewMigratorClass";
    @Nullable
    private String sourceViewName;
    @Nullable
    private String targetViewName;
    @Nullable
    private Boolean deleteOriginalView;
    private boolean returned;
    @Nullable
    private JCas newJCas;
    @Nullable
    private Class<? extends ViewMigrator> viewMigratorClass;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.sourceViewName = (String)aContext.getConfigParameterValue(PARAM_SOURCE_VIEW_NAME);
        this.targetViewName = (String)aContext.getConfigParameterValue(PARAM_TARGET_VIEW_NAME);
        this.deleteOriginalView = (Boolean)aContext.getConfigParameterValue(PARAM_DELETE_ORIGINAL_VIEW);
        try {
            String className = (String)aContext.getConfigParameterValue(PARAM_VIEW_MIGRATOR_CLASS);
            this.viewMigratorClass = Class.forName(className).asSubclass(ViewMigrator.class);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        Iterator viewIterator;
        Objects.requireNonNull(this.sourceViewName);
        Objects.requireNonNull(this.targetViewName);
        Objects.requireNonNull(this.viewMigratorClass);
        this.returned = false;
        this.newJCas = this.getEmptyJCas();
        Objects.requireNonNull(this.newJCas);
        try {
            viewIterator = aJCas.getViewIterator();
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        while (viewIterator.hasNext()) {
            JCas newView;
            JCas view = (JCas)viewIterator.next();
            String viewName = view.getViewName();
            if (this.sourceViewName.equals(viewName)) {
                JCas targetView;
                try {
                    targetView = this.newJCas.createView(this.targetViewName);
                }
                catch (CASException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                try {
                    this.viewMigratorClass.newInstance().migrate(view, targetView);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                if (this.deleteOriginalView != null && this.deleteOriginalView.booleanValue()) continue;
            }
            try {
                newView = "_InitialView".equals(viewName) ? this.newJCas.getView(viewName) : this.newJCas.createView(viewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            new ViewCopier().migrate(view, newView);
        }
    }

    public boolean hasNext() {
        return !this.returned;
    }

    public AbstractCas next() {
        this.returned = true;
        return this.newJCas;
    }
}

