/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.migration;

import com.google.common.base.Preconditions;
import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.uima.copying.UimaCopying;
import edu.umn.biomedicus.uima.migration.TypeConversion;
import edu.umn.biomedicus.uima.migration.TypeSystemMigration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasMultiplier_ImplBase;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;

public class MigratorEngine
extends CasMultiplier_ImplBase {
    @Nullable
    private TypeSystemMigration migration;
    private boolean casReturned = false;
    private CAS newCas;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String migrationClassName = (String)aContext.getConfigParameterValue("migration");
        try {
            this.migration = Class.forName(migrationClassName).asSubclass(TypeSystemMigration.class).newInstance();
            Preconditions.checkNotNull((Object)this.migration);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public boolean hasNext() {
        return !this.casReturned;
    }

    public AbstractCas next() {
        this.casReturned = true;
        return this.newCas;
    }

    public void process(CAS aCAS) {
        assert (this.migration != null) : "migration should never be null at this point";
        TypeSystem typeSystem = aCAS.getTypeSystem();
        this.newCas = this.getEmptyCAS();
        this.casReturned = false;
        this.migration.setupDocument(aCAS, this.newCas);
        boolean deleteByDefault = this.migration.deleteByDefault();
        List<String> typesNotDefaulted = this.migration.typesNotDefaulted();
        for (Pair<String, String> viewMigration : this.migration.viewMigrations()) {
            String fromViewName = (String)viewMigration.first();
            String toViewName = (String)viewMigration.second();
            CAS fromView = fromViewName.equals("_InitialView") ? aCAS : aCAS.getView(fromViewName);
            CAS toView = toViewName.equals("_InitialView") ? this.newCas : this.newCas.createView(toViewName);
            ArrayList<String> converted = new ArrayList<String>();
            this.migration.setupView(fromView, toView);
            List<TypeConversion> typeConversions = this.migration.getTypeConversions();
            for (TypeConversion typeConversion : typeConversions) {
                String sourceTypeName = typeConversion.sourceTypeName();
                converted.add(sourceTypeName);
                Type sourceType = typeSystem.getType(sourceTypeName);
                FSIndexRepository indexRepository = fromView.getIndexRepository();
                FSIterator allIndexedFS = indexRepository.getAllIndexedFS(sourceType);
                while (allIndexedFS.hasNext()) {
                    FeatureStructure from = (FeatureStructure)allIndexedFS.next();
                    typeConversion.doMigrate(fromView, toView, from, sourceType);
                }
            }
            FSIterator allFSes = fromView.getIndexRepository().getAllIndexedFS(fromView.getTypeSystem().getType("uima.cas.TOP"));
            while (allFSes.hasNext()) {
                boolean doDefault;
                FeatureStructure next = (FeatureStructure)allFSes.next();
                String typeName = next.getType().getName();
                if (converted.contains(typeName)) continue;
                boolean bl = doDefault = !typesNotDefaulted.contains(typeName);
                if ((deleteByDefault || !doDefault) && (!deleteByDefault || doDefault)) continue;
                UimaCopying.copyFeatureStructure(next, toView);
            }
        }
    }
}

