/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.reader.State;
import edu.umn.biomedicus.uima.rtf.PropertyCasMapping;
import javax.annotation.Nullable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;

class AnnotationPropertyWatcher {
    private final PropertyCasMapping propertyCasMapping;
    @Nullable
    private Integer begin = null;
    @Nullable
    private Integer value = null;

    AnnotationPropertyWatcher(PropertyCasMapping propertyCasMapping) {
        this.propertyCasMapping = propertyCasMapping;
    }

    @Nullable
    AnnotationFS handleChanges(int index, State state, CAS jCas) {
        if (index < 0) {
            throw new IllegalArgumentException("Index less than 0");
        }
        if (this.begin != null && index < this.begin) {
            throw new IllegalStateException("Index before the beginning of the currently tracked annotation.");
        }
        int propertyValue = this.propertyCasMapping.getPropertyValue(state);
        AnnotationFS finished = null;
        if (this.begin != null && this.value != null && this.value != propertyValue) {
            finished = this.propertyCasMapping.getAnnotation(jCas, this.begin, index, this.value);
            this.begin = null;
            this.value = null;
        }
        if (this.begin == null && this.propertyCasMapping.test(propertyValue)) {
            this.begin = index;
            this.value = propertyValue;
        }
        return finished;
    }
}

