/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.reader.IndexListener;
import edu.umn.nlpengine.TextRange;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

class CasIndexListener
implements IndexListener {
    private final CAS originalDocumentView;
    private final Type viewIndexType;
    private final Feature destinationNameFeature;
    private final Feature destinationIndexFeature;

    CasIndexListener(CAS originalDocumentView) {
        this.originalDocumentView = originalDocumentView;
        this.viewIndexType = originalDocumentView.getTypeSystem().getType("biomedicus.v2.rtf.ViewIndex");
        this.destinationIndexFeature = this.viewIndexType.getFeatureByBaseName("destinationIndex");
        this.destinationNameFeature = this.viewIndexType.getFeatureByBaseName("destinationName");
    }

    public void wroteToDestination(String destinationName, int destinationIndex, TextRange originalDocumentTextLocation) {
        AnnotationFS viewIndex = this.originalDocumentView.createAnnotation(this.viewIndexType, originalDocumentTextLocation.getStartIndex(), originalDocumentTextLocation.getEndIndex());
        viewIndex.setStringValue(this.destinationNameFeature, destinationName);
        viewIndex.setIntValue(this.destinationIndexFeature, destinationIndex);
        this.originalDocumentView.addFsToIndexes((FeatureStructure)viewIndex);
    }
}

