/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.reader.KeywordAction;
import edu.umn.biomedicus.rtf.reader.OutputDestination;
import edu.umn.biomedicus.rtf.reader.State;
import edu.umn.biomedicus.uima.rtf.AnnotationPropertyWatcher;
import edu.umn.biomedicus.uima.rtf.PropertyCasMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;

class CasOutputDestination
implements OutputDestination {
    private final CAS destinationView;
    private final StringBuilder sofaBuilder;
    private final Collection<AnnotationFS> completedAnnotations;
    private final Collection<AnnotationPropertyWatcher> annotationPropertyWatchers;
    private final Map<String, Type> annotationTypeForControlWord;
    private final String name;
    private final Type illegalCharType;
    private final Feature valueFeat;
    private final boolean writeTables;
    private boolean inSuperSub = false;

    CasOutputDestination(CAS destinationView, List<PropertyCasMapping> casMappings, Map<String, Type> annotationTypeForControlWord, String name, boolean writeTables) {
        this.destinationView = destinationView;
        this.sofaBuilder = new StringBuilder();
        this.completedAnnotations = new ArrayList<AnnotationFS>();
        this.annotationPropertyWatchers = casMappings.stream().map(AnnotationPropertyWatcher::new).collect(Collectors.toList());
        this.annotationTypeForControlWord = annotationTypeForControlWord;
        this.name = name;
        this.writeTables = writeTables;
        TypeSystem typeSystem = destinationView.getTypeSystem();
        this.illegalCharType = typeSystem.getType("biomedicus.v2.rtf.IllegalXmlCharacter");
        this.valueFeat = this.illegalCharType.getFeatureByBaseName("value");
    }

    public int writeChar(char ch, State state) {
        for (AnnotationPropertyWatcher propertyWatcher : this.annotationPropertyWatchers) {
            AnnotationFS newAnnotation = propertyWatcher.handleChanges(this.sofaBuilder.length(), state, this.destinationView);
            if (newAnnotation == null) continue;
            this.completedAnnotations.add(newAnnotation);
        }
        if (state.getPropertyValue("CharacterFormatting", "Hidden") == 0 && (this.writeTables || state.getPropertyValue("ParagraphFormatting", "InTable") == 0)) {
            if (!this.isValidXml(ch)) {
                this.sofaBuilder.append('\u200b');
                AnnotationFS annotation = this.destinationView.createAnnotation(this.illegalCharType, this.sofaBuilder.length() - 1, this.sofaBuilder.length());
                annotation.setIntValue(this.valueFeat, (int)ch);
                this.completedAnnotations.add(annotation);
            } else {
                int superSub = state.getPropertyValue("CharacterFormatting", "SuperSub");
                if (superSub > 0) {
                    if (!this.inSuperSub) {
                        this.inSuperSub = true;
                        if (Character.isDigit(this.sofaBuilder.charAt(this.sofaBuilder.length() - 1)) && Character.isDigit(ch)) {
                            this.sofaBuilder.append('^');
                        }
                        this.sofaBuilder.append('(');
                    }
                } else if (this.inSuperSub) {
                    this.sofaBuilder.append(')');
                    this.inSuperSub = false;
                }
                this.sofaBuilder.append(ch);
            }
            return this.sofaBuilder.length() - 1;
        }
        return -1;
    }

    private boolean isValidXml(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd';
    }

    public void finishDestination() {
        this.destinationView.setDocumentText(this.sofaBuilder.toString());
        this.completedAnnotations.forEach(arg_0 -> ((CAS)this.destinationView).addFsToIndexes(arg_0));
    }

    public void controlWordEncountered(KeywordAction keywordAction) {
        int currentTextIndex = this.sofaBuilder.length();
        String controlWord = keywordAction.getControlWord();
        if (!this.annotationTypeForControlWord.containsKey(controlWord)) {
            return;
        }
        Type type = this.annotationTypeForControlWord.get(controlWord);
        AnnotationFS annotation = this.destinationView.createAnnotation(type, currentTextIndex, currentTextIndex);
        Feature paramFeature = type.getFeatureByBaseName("param");
        if (keywordAction.hasParameter()) {
            annotation.setIntValue(paramFeature, keywordAction.getParameter());
        }
        Feature indexFeature = type.getFeatureByBaseName("index");
        annotation.setIntValue(indexFeature, keywordAction.getBegin());
        Feature knownFeature = type.getFeatureByBaseName("known");
        annotation.setBooleanValue(knownFeature, true);
        this.destinationView.addFsToIndexes((FeatureStructure)annotation);
    }

    public String getName() {
        return this.name;
    }
}

