/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.reader.OutputDestination;
import edu.umn.biomedicus.rtf.reader.OutputDestinationFactory;
import edu.umn.biomedicus.uima.rtf.CasOutputDestination;
import edu.umn.biomedicus.uima.rtf.DestinationCasMapping;
import edu.umn.biomedicus.uima.rtf.IgnoreOutputDestination;
import edu.umn.biomedicus.uima.rtf.PropertyCasMapping;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;

class CasOutputDestinationFactory
implements OutputDestinationFactory {
    private final List<DestinationCasMapping> destinationCasMappings;
    private final Map<String, Type> annotationTypeForSymbolName;
    private final List<PropertyCasMapping> propertyCasMappings;
    private final CAS cas;
    private final boolean writeTables;

    CasOutputDestinationFactory(List<DestinationCasMapping> destinationCasMappings, Map<String, Type> annotationTypeForSymbolName, List<PropertyCasMapping> propertyCasMappings, CAS cas, boolean writeTables) {
        this.destinationCasMappings = destinationCasMappings;
        this.annotationTypeForSymbolName = annotationTypeForSymbolName;
        this.propertyCasMappings = propertyCasMappings;
        this.cas = cas;
        this.writeTables = writeTables;
    }

    public OutputDestination create(String destinationName) {
        DestinationCasMapping matchingCasMapping = null;
        for (DestinationCasMapping destMapping : this.destinationCasMappings) {
            if (!destinationName.equals(destMapping.getDestinationName())) continue;
            matchingCasMapping = destMapping;
        }
        if (matchingCasMapping == null) {
            return new IgnoreOutputDestination(destinationName);
        }
        CAS newView = this.cas.createView(matchingCasMapping.getViewName());
        return new CasOutputDestination(newView, this.propertyCasMappings, this.annotationTypeForSymbolName, destinationName, this.writeTables);
    }
}

