/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphAnnotator
extends CasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParagraphAnnotator.class);
    private String documentName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.documentName = (String)aContext.getConfigParameterValue("documentName");
    }

    public void process(CAS aCAS) {
        LOGGER.trace("Annotating rtf paragraphs.");
        CAS systemView = aCAS.getView(this.documentName);
        Type newParagraphType = systemView.getTypeSystem().getType("biomedicus.v2.rtf.NewParagraph");
        Type paragraphType = systemView.getTypeSystem().getType("biomedicus.v2.Paragraph");
        AnnotationIndex newParagraphIndex = systemView.getAnnotationIndex(newParagraphType);
        int start = 0;
        for (AnnotationFS newParagraph : newParagraphIndex) {
            int end = newParagraph.getEnd();
            systemView.addFsToIndexes((FeatureStructure)systemView.createAnnotation(paragraphType, start, end));
            start = end;
        }
    }
}

