/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.reader.State;
import edu.umn.biomedicus.uima.rtf.PropertyCasMappingAdapter;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;

@XmlJavaTypeAdapter(value=PropertyCasMappingAdapter.class)
public class PropertyCasMapping {
    private final String propertyGroup;
    private final String propertyName;
    private final String annotationClassName;
    private final int minimumValue;
    @Nullable
    private final Integer maximumValue;
    private final boolean valueIncluded;
    private final boolean zeroLengthEmitted;

    public PropertyCasMapping(String propertyGroup, String propertyName, String annotationClassName, int minimumValue, @Nullable Integer maximumValue, boolean valueIncluded, boolean zeroLengthEmitted) {
        this.propertyGroup = propertyGroup;
        this.propertyName = propertyName;
        this.annotationClassName = annotationClassName;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.valueIncluded = valueIncluded;
        this.zeroLengthEmitted = zeroLengthEmitted;
    }

    @Nullable
    AnnotationFS getAnnotation(CAS cas, int begin, int end, int value) {
        if (begin < 0) {
            throw new IllegalArgumentException("Begin: " + begin + "before 0.");
        }
        if (end < begin) {
            throw new IllegalArgumentException(this.annotationClassName + " - illegal annotation span at begin: " + begin + " end: " + end);
        }
        if (!this.zeroLengthEmitted && end == begin) {
            return null;
        }
        TypeSystem typeSystem = cas.getTypeSystem();
        Type type = typeSystem.getType(this.annotationClassName);
        if (type == null) {
            throw new IllegalStateException("Annotation class not found: " + this.annotationClassName);
        }
        AnnotationFS annotation = cas.createAnnotation(type, begin, end);
        if (this.valueIncluded) {
            Feature valueFeature = type.getFeatureByBaseName("value");
            annotation.setIntValue(valueFeature, value);
        }
        return annotation;
    }

    boolean test(int value) {
        return value >= this.minimumValue && (this.maximumValue == null || value <= this.maximumValue);
    }

    int getPropertyValue(State state) {
        return state.getPropertyValue(this.propertyGroup, this.propertyName);
    }

    public String getPropertyGroup() {
        return this.propertyGroup;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    @Nullable
    public Integer getMaximumValue() {
        return this.maximumValue;
    }

    public boolean isValueIncluded() {
        return this.valueIncluded;
    }

    public boolean isZeroLengthEmitted() {
        return this.zeroLengthEmitted;
    }
}

