/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.exc.RtfReaderException;
import edu.umn.biomedicus.rtf.reader.ReaderRtfSource;
import edu.umn.biomedicus.rtf.reader.RtfParser;
import edu.umn.biomedicus.rtf.reader.RtfSource;
import edu.umn.biomedicus.uima.adapter.UimaAdapters;
import edu.umn.biomedicus.uima.rtf.RtfParserFactory;
import edu.umn.nlpengine.Artifact;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtfParserAnnotator
extends CasAnnotator_ImplBase {
    public static final String PARAM_ORIGINAL_DOCUMENT_VIEW_NAME = "rtfDocumentName";
    public static final String PARAM_TARGET_VIEW_NAME = "documentName";
    public static final String PARAM_RTF_PROPERTIES_DESC = "rtfPropertiesDesc";
    public static final String PARAM_RTF_CONTROL_KEYWORDS_DESC = "rtfControlKeywordsDesc";
    public static final String PARAM_RTF_CAS_MAPPINGS_DESC = "rtfCasMappingsDesc";
    public static final String PARAM_WRITE_TABLES = "writeTables";
    private static final Logger LOGGER = LoggerFactory.getLogger(RtfParserAnnotator.class);
    @Nullable
    private RtfParserFactory rtfParserFactory;
    @Nullable
    private String originalDocumentViewName;
    @Nullable
    private String targetViewName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        LOGGER.info("initializing rtf parser");
        String rtfPropertiesDesc = (String)aContext.getConfigParameterValue(PARAM_RTF_PROPERTIES_DESC);
        String rtfControlKeywordsDesc = (String)aContext.getConfigParameterValue(PARAM_RTF_CONTROL_KEYWORDS_DESC);
        String rtfCasMappingsDesc = (String)aContext.getConfigParameterValue(PARAM_RTF_CAS_MAPPINGS_DESC);
        Boolean writeTables = (Boolean)aContext.getConfigParameterValue(PARAM_WRITE_TABLES);
        this.rtfParserFactory = RtfParserFactory.createByLoading(rtfPropertiesDesc, rtfControlKeywordsDesc, rtfCasMappingsDesc, writeTables);
        this.originalDocumentViewName = (String)aContext.getConfigParameterValue(PARAM_ORIGINAL_DOCUMENT_VIEW_NAME);
        this.targetViewName = (String)aContext.getConfigParameterValue(PARAM_TARGET_VIEW_NAME);
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        boolean isRtf;
        Objects.requireNonNull(this.rtfParserFactory);
        Objects.requireNonNull(this.originalDocumentViewName);
        Objects.requireNonNull(this.targetViewName);
        LOGGER.trace("Parsing an rtf document from {} into CAS", (Object)this.originalDocumentViewName);
        CAS originalDocument = aCAS.getView(this.originalDocumentViewName);
        String documentText = originalDocument.getDocumentText();
        Artifact artifact = UimaAdapters.getArtifact(aCAS, null);
        boolean parsed = false;
        if (documentText.indexOf("{\\rtf1") == 0) {
            RtfParser parser;
            StringReader reader = new StringReader(documentText);
            ReaderRtfSource rtfSource = new ReaderRtfSource((Reader)reader);
            try {
                parser = this.rtfParserFactory.createParser(aCAS, (RtfSource)rtfSource);
            }
            catch (RtfReaderException e) {
                LOGGER.error("Failed to initialize rtf parser.");
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                parser.parseFile();
                parsed = true;
            }
            catch (RtfReaderException e) {
                LOGGER.warn("Irrecoverable error during parsing: " + artifact.getArtifactID(), (Throwable)e);
            }
            if (!parser.finish()) {
                LOGGER.warn("Document with unclosed Rtf group(s): " + artifact.getArtifactID());
                parsed = false;
            }
            isRtf = true;
        } else {
            CAS targetView = aCAS.createView(this.targetViewName);
            targetView.setDocumentText(documentText);
            isRtf = false;
        }
        if (!parsed) {
            LOGGER.warn("Failed to completely parse document from rtf: " + artifact.getArtifactID());
        }
        artifact.getMetadata().put("isRtfComplete", Boolean.toString(parsed));
        artifact.getMetadata().put("isRtf", Boolean.toString(isRtf));
    }
}

