/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.rtf.beans.keywords.ControlKeywordsDescription;
import edu.umn.biomedicus.rtf.beans.properties.PropertiesDescription;
import edu.umn.biomedicus.rtf.exc.RtfReaderException;
import edu.umn.biomedicus.rtf.reader.IndexListener;
import edu.umn.biomedicus.rtf.reader.OutputDestinationFactory;
import edu.umn.biomedicus.rtf.reader.RtfKeywordParser;
import edu.umn.biomedicus.rtf.reader.RtfParser;
import edu.umn.biomedicus.rtf.reader.RtfSource;
import edu.umn.biomedicus.rtf.reader.State;
import edu.umn.biomedicus.uima.rtf.CasIndexListener;
import edu.umn.biomedicus.uima.rtf.CasMappings;
import edu.umn.biomedicus.uima.rtf.CasOutputDestinationFactory;
import edu.umn.biomedicus.uima.rtf.ControlWordCasMapping;
import edu.umn.biomedicus.uima.rtf.DestinationCasMapping;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;

class RtfParserFactory {
    private final Map<String, Map<String, Integer>> initialProperties;
    private final RtfKeywordParser rtfKeywordParser;
    private final CasMappings casMappings;
    private final boolean writeTables;

    RtfParserFactory(Map<String, Map<String, Integer>> initialProperties, RtfKeywordParser rtfKeywordParser, CasMappings casMappings, boolean writeTables) {
        this.initialProperties = initialProperties;
        this.rtfKeywordParser = rtfKeywordParser;
        this.casMappings = casMappings;
        this.writeTables = writeTables;
    }

    static RtfParserFactory createByLoading(String propertiesDescriptionClasspathRef, String controlKeywordsDescriptionClasspathRef, String casMappingsDescriptionClassPathRef, boolean writeTables) {
        PropertiesDescription propertiesDescription = PropertiesDescription.loadFromFile((String)propertiesDescriptionClasspathRef);
        Map properties = propertiesDescription.createProperties();
        ControlKeywordsDescription controlKeywordsDescription = ControlKeywordsDescription.loadFromFile((String)controlKeywordsDescriptionClasspathRef);
        Map keywordActionMap = controlKeywordsDescription.getKeywordActionsAsMap();
        CasMappings casMappings = CasMappings.loadFromFile(casMappingsDescriptionClassPathRef);
        RtfKeywordParser rtfKeywordParser = new RtfKeywordParser(keywordActionMap);
        return new RtfParserFactory(properties, rtfKeywordParser, casMappings, writeTables);
    }

    RtfParser createParser(CAS cas, RtfSource rtfSource) throws RtfReaderException {
        List<DestinationCasMapping> destinationCasMappings = this.casMappings.getDestinationCasMappings();
        Map<String, Type> annotationTypeForSymbolName = this.casMappings.getControlWordCasMappings().stream().collect(Collectors.toMap(ControlWordCasMapping::getControlWord, p -> cas.getTypeSystem().getType(p.getAnnotationName())));
        CasOutputDestinationFactory outputDestinationFactory = new CasOutputDestinationFactory(destinationCasMappings, annotationTypeForSymbolName, this.casMappings.getPropertyCasMappings(), cas, this.writeTables);
        CAS originalDocumentView = cas.getView("OriginalDocument");
        CasIndexListener indexListener = new CasIndexListener(originalDocumentView);
        State initialState = State.createState((OutputDestinationFactory)outputDestinationFactory, this.initialProperties, (IndexListener)indexListener);
        return new RtfParser(this.rtfKeywordParser, rtfSource, initialState);
    }
}

