/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;

class TableAnnotationDivider {
    private final CAS cas;
    @Nullable
    private AnnotationIndex<AnnotationFS> annotations;
    @Nullable
    private AnnotationIndex<AnnotationFS> dividers;
    @Nullable
    private Type typeToCreate;

    private TableAnnotationDivider(CAS cas) {
        this.cas = cas;
    }

    static TableAnnotationDivider in(CAS cas) {
        return new TableAnnotationDivider(cas);
    }

    TableAnnotationDivider divide(Type annotationType) {
        this.annotations = this.cas.getAnnotationIndex(annotationType);
        return this;
    }

    TableAnnotationDivider using(Type dividerType) {
        this.dividers = this.cas.getAnnotationIndex(dividerType);
        return this;
    }

    TableAnnotationDivider into(Type type) {
        this.typeToCreate = type;
        return this;
    }

    void execute() {
        Objects.requireNonNull(this.annotations);
        this.annotations.forEach(this::divideAnnotation);
        this.annotations = null;
        this.dividers = null;
    }

    private void divideAnnotation(AnnotationFS annotation) {
        Objects.requireNonNull(this.typeToCreate);
        Objects.requireNonNull(this.dividers);
        FSIterator subiterator = this.dividers.subiterator(annotation);
        int begin = annotation.getBegin();
        while (subiterator.hasNext()) {
            int end = ((AnnotationFS)subiterator.next()).getBegin();
            this.cas.addFsToIndexes((FeatureStructure)this.cas.createAnnotation(this.typeToCreate, begin, end));
            begin = end;
        }
    }
}

