/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtf;

import edu.umn.biomedicus.uima.rtf.TableAnnotationDivider;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAnnotator
extends CasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableAnnotator.class);
    private String documentName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.documentName = (String)aContext.getConfigParameterValue("documentName");
    }

    public void process(CAS aCAS) {
        LOGGER.trace("Annotating rtf tables.");
        CAS systemView = aCAS.getView(this.documentName);
        TypeSystem typeSystem = aCAS.getTypeSystem();
        Type intblType = typeSystem.getType("biomedicus.v2.rtf.ParagraphInTable");
        Type rowEndType = typeSystem.getType("biomedicus.v2.rtf.RowEnd");
        Type rowType = typeSystem.getType("biomedicus.v2.Row");
        ArrayList<Integer> intblBegins = new ArrayList<Integer>();
        AnnotationIndex intblIndex = systemView.getAnnotationIndex(intblType);
        for (AnnotationFS annotationFS : intblIndex) {
            intblBegins.add(annotationFS.getBegin());
        }
        ArrayList<Integer> rowEnds = new ArrayList<Integer>();
        AnnotationIndex rowEndIndex = systemView.getAnnotationIndex(rowEndType);
        for (Object rowEndAnnotation : rowEndIndex) {
            rowEnds.add(rowEndAnnotation.getBegin());
        }
        int last = 0;
        for (Integer intblBegin : intblBegins) {
            int insert;
            if (intblBegin < last || (insert = Collections.binarySearch(rowEnds, intblBegin)) >= 0) continue;
            if ((insert = insert * -1 - 1) == rowEnds.size()) {
                LOGGER.warn("Rtf intbl paragraph after the last row end.");
                continue;
            }
            int end = (Integer)rowEnds.get(insert);
            systemView.addFsToIndexes((FeatureStructure)systemView.createAnnotation(rowType, intblBegin.intValue(), end));
        }
        Type cellEndType = typeSystem.getType("biomedicus.v2.rtf.CellEnd");
        Type cellType = typeSystem.getType("biomedicus.v2.Cell");
        Type nestRowEndType = typeSystem.getType("biomedicus.v2.rtf.NestRowEnd");
        Type nestedRowType = typeSystem.getType("biomedicus.v2.NestedRow");
        Type nestedCellEndType = typeSystem.getType("biomedicus.v2.rtf.NestCellEnd");
        Type nestedCellType = typeSystem.getType("biomedicus.v2.NestedCell");
        TableAnnotationDivider tableAnnotationDivider = TableAnnotationDivider.in(systemView);
        tableAnnotationDivider.using(cellEndType).divide(rowType).into(cellType).execute();
        tableAnnotationDivider.using(nestRowEndType).divide(cellType).into(nestedRowType).execute();
        tableAnnotationDivider.using(nestedCellEndType).divide(nestedRowType).into(nestedCellType).execute();
    }
}

