/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtfrewriting;

import edu.umn.biomedicus.uima.adapter.UimaAdapters;
import edu.umn.biomedicus.uima.rtfrewriting.RegionTaggerBuilder;
import edu.umn.biomedicus.uima.rtfrewriting.SymbolIndexedDocument;
import edu.umn.nlpengine.Artifact;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class AnnotationInsertingWriter
extends CasAnnotator_ImplBase {
    @Nullable
    private String[] annotationTypes = null;
    @Nullable
    private Path outputDir;
    private String documentName;
    private String rtfDocumentName;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.annotationTypes = (String[])aContext.getConfigParameterValue("annotationTypes");
        this.outputDir = Paths.get((String)aContext.getConfigParameterValue("outputDirectory"), new String[0]);
        try {
            Files.createDirectories(this.outputDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.documentName = (String)aContext.getConfigParameterValue("documentName");
        this.rtfDocumentName = (String)aContext.getConfigParameterValue("rtfDocumentName");
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        CAS originalDocumentView = aCAS.getView(this.rtfDocumentName);
        SymbolIndexedDocument symbolIndexedDocument = SymbolIndexedDocument.fromView(originalDocumentView);
        CAS view = aCAS.getView(this.documentName);
        TreeSet covered = new TreeSet();
        for (String annotationType : Objects.requireNonNull(this.annotationTypes)) {
            Type type = view.getTypeSystem().getType(annotationType);
            AnnotationIndex annotationIndex = view.getAnnotationIndex(type);
            for (Annotation annotation : annotationIndex) {
                IntStream.rangeClosed(annotation.getBegin(), annotation.getEnd()).forEach(covered::add);
            }
        }
        Iterator iterator2 = covered.iterator();
        int next = (Integer)iterator2.next();
        int last = -1;
        while (iterator2.hasNext()) {
            int first = next;
            while (iterator2.hasNext()) {
                last = next;
                next = (Integer)iterator2.next();
                if (next - last <= 1) continue;
            }
            RegionTaggerBuilder.create().withBeginTag("\\u2222221B ").withEndTag("\\u2222221E ").withSymbolIndexedDocument(symbolIndexedDocument).withDestinationName(this.documentName).withBegin(first).withEnd(last).createRegionTagger().tagRegion();
        }
        String rewrittenDocument = symbolIndexedDocument.getDocument();
        Artifact artifact = UimaAdapters.getArtifact(aCAS, null);
        Path file = this.outputDir.resolve(artifact.getArtifactID() + ".rtf");
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            bufferedWriter.write(rewrittenDocument);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

