/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtfrewriting;

import edu.umn.biomedicus.uima.rtfrewriting.RtfRewriterCursor;
import edu.umn.biomedicus.uima.rtfrewriting.SymbolIndexedDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionTagger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionTagger.class);
    private final String destinationName;
    private final int beginIndex;
    private final int endIndex;
    private final String beginTag;
    private final String endTag;
    private final RtfRewriterCursor rtfRewriterCursor;

    public RegionTagger(SymbolIndexedDocument symbolIndexedDocument, String destinationName, int beginDestinationIndex, int endDestinationIndex, String beginTag, String endTag) {
        this.destinationName = destinationName;
        this.beginIndex = symbolIndexedDocument.symbolIndex(beginDestinationIndex, destinationName);
        this.endIndex = symbolIndexedDocument.symbolIndex(endDestinationIndex - 1, destinationName);
        this.beginTag = beginTag;
        this.endTag = endTag;
        this.rtfRewriterCursor = new RtfRewriterCursor(symbolIndexedDocument);
    }

    public void tagRegion() {
        int remaining;
        LOGGER.debug("Tagging a region between symbols {} and {} in {}", new Object[]{this.beginIndex, this.endIndex, this.destinationName});
        this.rtfRewriterCursor.setSymbolIndex(this.beginIndex);
        this.rtfRewriterCursor.insertBefore(this.beginTag);
        while ((remaining = this.endIndex - this.rtfRewriterCursor.getSymbolIndex()) != 0) {
            if (remaining < 0) {
                String msg = String.format("Passed the end symbol in document by %d symbols, context: \"%s\"", remaining * -1, this.rtfRewriterCursor.getContext());
                LOGGER.error(msg);
                throw new IllegalStateException(msg);
            }
            if (this.rtfRewriterCursor.nextIsOutsideDestination(this.destinationName)) {
                this.rtfRewriterCursor.insertAfter(this.endTag);
                this.rtfRewriterCursor.forward();
                this.rtfRewriterCursor.advanceToDestination(this.destinationName);
                this.rtfRewriterCursor.insertBefore(this.beginTag);
                continue;
            }
            if (this.rtfRewriterCursor.nextOffsetNonZero()) {
                this.rtfRewriterCursor.insertAfter(this.endTag);
                this.rtfRewriterCursor.forward();
                this.rtfRewriterCursor.insertBefore(this.beginTag);
                continue;
            }
            this.rtfRewriterCursor.forward();
        }
        this.rtfRewriterCursor.insertAfter(this.endTag);
    }
}

