/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtfrewriting;

import edu.umn.biomedicus.uima.rtfrewriting.SymbolIndexedDocument;

public class RtfRewriterCursor {
    private final SymbolIndexedDocument symbolIndexedDocument;
    private int symbolIndex = -1;

    public RtfRewriterCursor(SymbolIndexedDocument symbolIndexedDocument) {
        this.symbolIndexedDocument = symbolIndexedDocument;
    }

    public void moveTo(int index, String destinationName) {
        this.symbolIndex = this.symbolIndexedDocument.symbolIndex(index, destinationName);
    }

    public void insertBefore(String tag) {
        if (this.symbolIndex == -1) {
            throw new IllegalStateException();
        }
        this.symbolIndexedDocument.insertBeforeSymbol(this.symbolIndex, tag);
    }

    public void insertAfter(String tag) {
        if (this.symbolIndex == -1) {
            throw new IllegalStateException();
        }
        this.symbolIndexedDocument.insertTextAfter(this.symbolIndex, tag);
    }

    public void forward() {
        ++this.symbolIndex;
    }

    public void back() {
        --this.symbolIndex;
    }

    public boolean nextIsOutsideDestination(String destinationName) {
        return this.symbolIndexedDocument.symbolIsOutsideDestination(this.symbolIndex + 1, destinationName);
    }

    public void advanceToDestination(String destinationName) {
        while (this.symbolIndexedDocument.symbolIsOutsideDestination(this.symbolIndex, destinationName)) {
            ++this.symbolIndex;
        }
    }

    public int getSymbolIndex() {
        return this.symbolIndex;
    }

    public void setSymbolIndex(int symbolIndex) {
        this.symbolIndex = symbolIndex;
    }

    public boolean nextOffsetNonZero() {
        return this.symbolIndexedDocument.symbolOffsetIsNonZero(this.symbolIndex + 1);
    }

    public String getContext() {
        return this.symbolIndexedDocument.getContext(this.symbolIndex);
    }
}

