/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtfrewriting;

import edu.umn.biomedicus.uima.rtfrewriting.SymbolLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;

public class SymbolIndexedDocument {
    private final List<SymbolLocation> symbolLocations;
    private final Map<String, Map<Integer, Integer>> destinationMap;
    private StringBuilder document;

    private SymbolIndexedDocument(List<SymbolLocation> symbolLocations, Map<String, Map<Integer, Integer>> destinationMap, String document) {
        this.symbolLocations = symbolLocations;
        this.destinationMap = destinationMap;
        this.document = new StringBuilder(document);
    }

    public static SymbolIndexedDocument fromView(CAS originalDocumentView) {
        Type viewIndexType = originalDocumentView.getTypeSystem().getType("edu.umn.biomedicus.rtfuima.type.ViewIndex");
        Feature destinationNameFeature = viewIndexType.getFeatureByBaseName("destinationName");
        Feature destinationIndexFeature = viewIndexType.getFeatureByBaseName("destinationIndex");
        AnnotationIndex viewIndexAI = originalDocumentView.getAnnotationIndex(viewIndexType);
        ArrayList<SymbolLocation> symbolLocations = new ArrayList<SymbolLocation>();
        HashMap<String, Map<Integer, Integer>> destinationMap = new HashMap<String, Map<Integer, Integer>>();
        int index = 0;
        int lastEnd = 0;
        for (AnnotationFS annotation : viewIndexAI) {
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            String destinationName = annotation.getStringValue(destinationNameFeature);
            SymbolLocation symbolLocation = new SymbolLocation(destinationName, begin - lastEnd, end - begin, index++);
            symbolLocations.add(symbolLocation);
            int destinationIndex = annotation.getIntValue(destinationIndexFeature);
            destinationMap.compute(destinationName, (key, value) -> {
                if (value == null) {
                    value = new HashMap<Integer, Integer>();
                }
                value.put(destinationIndex, symbolLocations.size() - 1);
                return value;
            });
            lastEnd = end;
        }
        return new SymbolIndexedDocument(symbolLocations, destinationMap, originalDocumentView.getDocumentText());
    }

    public int symbolIndex(int characterIndex, String destinationName) {
        Map<Integer, Integer> indexesMap = this.destinationMap.get(destinationName);
        if (indexesMap == null) {
            throw new IllegalArgumentException("Destination does not exist");
        }
        Integer integer = indexesMap.get(characterIndex);
        if (integer == null) {
            throw new IllegalArgumentException("Character index does not map to a symbol");
        }
        return integer;
    }

    public String getDocument() {
        return this.document.toString();
    }

    public void insertBeforeSymbol(int symbolIndex, String text) {
        SymbolLocation symbolLocation = this.symbolLocations.get(symbolIndex);
        int insertionIndex = this.getOriginalDocumentIndex(symbolLocation);
        this.document.insert(insertionIndex, text);
        symbolLocation.addToOffset(text.length());
    }

    public void insertTextAfter(int symbolIndex, String text) {
        SymbolLocation symbolLocation = this.symbolLocations.get(symbolIndex);
        int insertionIndex = this.getOriginalDocumentIndex(symbolLocation) + symbolLocation.getLength();
        this.document.insert(insertionIndex, text);
        if (symbolIndex + 1 < this.symbolLocations.size()) {
            SymbolLocation nextSymbol = this.symbolLocations.get(symbolIndex + 1);
            nextSymbol.addToOffset(text.length());
        }
    }

    public int getOriginalDocumentIndex(SymbolLocation symbolLocation) {
        int index = symbolLocation.getOffset();
        for (int i = 0; i < symbolLocation.getIndex(); ++i) {
            SymbolLocation pointer = this.symbolLocations.get(i);
            index += pointer.getOffset();
            index += pointer.getLength();
        }
        return index;
    }

    public boolean symbolIsOutsideDestination(int symbolIndex, String destinationName) {
        return !this.symbolLocations.get(symbolIndex).getDestination().equals(destinationName);
    }

    public boolean symbolOffsetIsNonZero(int symbolIndex) {
        return this.symbolLocations.get(symbolIndex).getOffset() != 0;
    }

    public String getContext(int symbolIndex) {
        SymbolLocation symbolLocation = this.symbolLocations.get(symbolIndex);
        int insertionIndex = this.getOriginalDocumentIndex(symbolLocation);
        return this.document.substring(insertionIndex - 20, insertionIndex + 20);
    }
}

