/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.rtfrewriting;

class SymbolLocation {
    private final String destination;
    private final int index;
    private final int length;
    private int offset;

    SymbolLocation(String destination, int offset, int length, int index) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.destination = destination;
        this.offset = offset;
        this.length = length;
        this.index = index;
    }

    public String getDestination() {
        return this.destination;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void incrementOffset() {
        ++this.offset;
    }

    public void addToOffset(int increment) {
        this.offset += increment;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolLocation that = (SymbolLocation)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        return this.destination.equals(that.destination);
    }

    public int hashCode() {
        int result = this.destination.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        return result;
    }
}

