/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.util;

import java.util.Iterator;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationVerifier
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationVerifier.class);

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            Iterator viewIterator = aJCas.getViewIterator();
            while (viewIterator.hasNext()) {
                JCas view = (JCas)viewIterator.next();
                String sofaDataString = view.getSofaDataString();
                int length = sofaDataString != null ? sofaDataString.length() : -1;
                AnnotationIndex annotationIndex = view.getAnnotationIndex();
                for (Annotation annotation : annotationIndex) {
                    int end;
                    int begin = annotation.getBegin();
                    if (begin > (end = annotation.getEnd())) {
                        LOGGER.error("Annotation {} begin {} after end {}", new Object[]{annotation.getType().getName(), begin, end});
                    }
                    if (begin < 0) {
                        LOGGER.error("Annotation {} begin {} before 0", (Object)annotation.getType().getName(), (Object)begin);
                    }
                    if (end <= length) continue;
                    LOGGER.error("Annotation {} end {} after length of sofa {}", new Object[]{annotation.getType().getName(), end, length});
                }
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

