/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.util;

import javax.annotation.Nullable;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

public class FsAccessor {
    private final FeatureStructure featureStructure;
    private final Type type;

    public FsAccessor(FeatureStructure featureStructure) {
        this.featureStructure = featureStructure;
        this.type = featureStructure.getType();
    }

    public static FsAccessor create(AnnotationFS newNormForm) {
        return new FsAccessor((FeatureStructure)newNormForm);
    }

    public void setFeatureValue(String name, @Nullable Object value) {
        Feature feature = this.getFeature(name);
        if (value instanceof String) {
            this.featureStructure.setStringValue(feature, (String)value);
        } else if (value instanceof Integer) {
            this.featureStructure.setIntValue(feature, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.featureStructure.setLongValue(feature, ((Long)value).longValue());
        } else if (value instanceof Double) {
            this.featureStructure.setDoubleValue(feature, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.featureStructure.setFloatValue(feature, ((Float)value).floatValue());
        } else if (value instanceof FeatureStructure) {
            this.featureStructure.setFeatureValue(feature, (FeatureStructure)value);
        } else if (value instanceof Byte) {
            this.featureStructure.setByteValue(feature, ((Byte)value).byteValue());
        }
    }

    @Nullable
    public FeatureStructure getFeatureValue(String name) {
        return this.featureStructure.getFeatureValue(this.getFeature(name));
    }

    @Nullable
    public String getStringValue(String name) {
        return this.featureStructure.getStringValue(this.getFeature(name));
    }

    public double getDoubleValue(String name) {
        return this.featureStructure.getDoubleValue(this.getFeature(name));
    }

    public float getFloatValue(String name) {
        return this.featureStructure.getFloatValue(this.getFeature(name));
    }

    public int getIntValue(String name) {
        return this.featureStructure.getIntValue(this.getFeature(name));
    }

    public long getLongValue(String name) {
        return this.featureStructure.getLongValue(this.getFeature(name));
    }

    public Feature getFeature(String name) {
        return this.type.getFeatureByBaseName(name);
    }

    public boolean getBooleanValue(String name) {
        return this.featureStructure.getBooleanValue(this.getFeature(name));
    }
}

