/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRunCPE
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRunCPE.class);
    private final CollectionProcessingEngine collectionProcessingEngine;
    private final Semaphore completionSemaphore = new Semaphore(0);
    private int entityCount = 0;
    private long size = 0L;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    @Nullable
    private Consumer<CAS> casConsumer = null;

    public SimpleRunCPE(CpeDescription cpeDesc) throws ResourceInitializationException {
        LOGGER.info("Instantiating CPE");
        this.collectionProcessingEngine = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)cpeDesc);
        this.collectionProcessingEngine.addStatusCallbackListener(new StatusCallbackListener(){

            public void initializationComplete() {
                LOGGER.info("CPM Initialization Complete");
            }

            public void batchProcessComplete() {
                LOGGER.info("Completed " + SimpleRunCPE.this.entityCount + " documents");
                if (SimpleRunCPE.this.size > 0L) {
                    LOGGER.info("; " + SimpleRunCPE.this.size + " characters");
                }
            }

            public void collectionProcessComplete() {
                LOGGER.info("Completed " + SimpleRunCPE.this.entityCount + " documents");
                if (SimpleRunCPE.this.size > 0L) {
                    LOGGER.info("; " + SimpleRunCPE.this.size + " characters");
                }
                LOGGER.info("PERFORMANCE REPORT \n" + SimpleRunCPE.this.collectionProcessingEngine.getPerformanceReport().toString());
                SimpleRunCPE.this.completionSemaphore.release();
            }

            public void paused() {
                LOGGER.info("Paused");
            }

            public void resumed() {
                LOGGER.info("Resumed");
            }

            public void aborted() {
                LOGGER.error("CPE processing was aborted");
                SimpleRunCPE.this.completionSemaphore.release();
            }

            public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
                SimpleRunCPE.this.exceptions.addAll(aStatus.getExceptions());
                LOGGER.debug(aStatus.getStatusMessage());
                if (SimpleRunCPE.this.casConsumer != null) {
                    SimpleRunCPE.this.casConsumer.accept(aCas);
                }
                for (Exception exception : SimpleRunCPE.this.exceptions) {
                    LOGGER.error("Exception processing a CAS: ", (Throwable)exception);
                }
                SimpleRunCPE.this.entityCount++;
                String docText = aCas.getDocumentText();
                if (docText != null) {
                    SimpleRunCPE.this.size = SimpleRunCPE.this.size + (long)docText.length();
                }
            }
        });
    }

    public void setCasConsumer(@Nullable Consumer<CAS> casConsumer) {
        this.casConsumer = casConsumer;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public static void main(String[] args) {
        String descriptorPath = args[0];
        if (args.length < 1) {
            System.out.print(" Arguments to the program are as follows : \nargs[0] : path to CPE descriptor file");
            System.exit(1);
        }
        CpeDescription cpeDesc = null;
        try {
            cpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(descriptorPath));
        }
        catch (IOException | InvalidXMLException e) {
            System.err.print("Error parsing descriptor");
            System.exit(1);
        }
        SimpleRunCPE simpleRunCPE = null;
        try {
            simpleRunCPE = new SimpleRunCPE(cpeDesc);
            simpleRunCPE.runCPE();
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            simpleRunCPE.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (simpleRunCPE.exceptions.size() > 0) {
            System.exit(1);
        }
        System.exit(0);
    }

    public void runCPE() throws ResourceInitializationException {
        LOGGER.info("Running CPE");
        this.collectionProcessingEngine.process();
    }

    public void waitForCompletion() throws InterruptedException {
        this.completionSemaphore.acquire();
    }

    @Override
    public Void call() throws Exception {
        this.runCPE();
        this.waitForCompletion();
        return null;
    }
}

