/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.xmi;

import edu.umn.biomedicus.exc.BiomedicusException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Semaphore;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.xml.sax.SAXException;

public class TypeSystemWriter
extends Resource_ImplBase {
    private Semaphore writeOnce = new Semaphore(1);

    public void writeToPath(Path path) throws BiomedicusException {
        if (this.writeOnce.tryAcquire()) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                TypeSystemDescription description = this.getCasManager().getCasDefinition().getTypeSystemDescription();
                description.toXML((Writer)bufferedWriter);
            }
            catch (IOException | ResourceInitializationException | SAXException e) {
                throw new BiomedicusException(e);
            }
        }
    }
}

