/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.uima.xmi;

import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.uima.xmi.TypeSystemWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmiWriter
extends CasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmiWriter.class);
    @Nullable
    private TypeSystemWriter typeSystemWriter;
    @Nullable
    private Path outputDir;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        LOGGER.info("Initializing XMI writer AE");
        this.outputDir = Paths.get((String)context.getConfigParameterValue("outputDirectory"), new String[0]);
        try {
            Files.createDirectories(this.outputDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        try {
            this.typeSystemWriter = (TypeSystemWriter)((Object)context.getResourceObject("typeSystemWriter"));
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(CAS cas) throws AnalysisEngineProcessException {
        assert (this.typeSystemWriter != null);
        assert (this.outputDir != null);
        try {
            this.typeSystemWriter.writeToPath(this.outputDir.resolve("TypeSystem.xml"));
        }
        catch (BiomedicusException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        Type type = cas.getTypeSystem().getType("ArtifactID");
        Feature documentId = type.getFeatureByBaseName("artifactID");
        String fileName = ((FeatureStructure)cas.getView("metadata").getIndexRepository().getAllIndexedFS(type).next()).getStringValue(documentId) + ".xmi";
        Path path = this.outputDir.resolve(fileName);
        LOGGER.debug("Writing XMI CAS to location: {}", (Object)path.toString());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create directories for document: {}", (Object)path);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            XmiCasSerializer.serialize((CAS)cas, (OutputStream)out);
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Failed on document: {}", (Object)path);
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

