/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline;

import edu.usc.irds.agepredictor.cmdline.authorage.AgeClassifyEvaluatorTool;
import edu.usc.irds.agepredictor.cmdline.authorage.AgeClassifyTool;
import edu.usc.irds.agepredictor.cmdline.authorage.AgeClassifyTrainerTool;
import edu.usc.irds.agepredictor.cmdline.spark.authorage.AgeClassifySparkEvaluatorTool;
import edu.usc.irds.agepredictor.cmdline.spark.authorage.AgeClassifySparkTrainerTool;
import edu.usc.irds.agepredictor.cmdline.spark.authorage.AgePredictEvaluatorTool;
import edu.usc.irds.agepredictor.cmdline.spark.authorage.AgePredictTool;
import edu.usc.irds.agepredictor.cmdline.spark.authorage.AgePredictTrainerTool;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;
import opennlp.tools.formats.authorage.AuthorAgeSampleStreamFactory;

public class CLI {
    public static final String CMD = "bin/authorage";
    public static final String DEFAULT_FORMAT = "authorage";
    private static Map<String, CmdLineTool> toolLookupMap = new LinkedHashMap<String, CmdLineTool>();

    private static void usage() {
        System.out.println("Usage: bin/authorage TOOL");
        System.out.println("where TOOL is one of:");
        int numberOfSpaces = -1;
        for (String toolName : toolLookupMap.keySet()) {
            if (toolName.length() <= numberOfSpaces) continue;
            numberOfSpaces = toolName.length();
        }
        numberOfSpaces += 4;
        for (CmdLineTool tool : toolLookupMap.values()) {
            System.out.print("  " + tool.getName());
            for (int i = 0; i < Math.abs(tool.getName().length() - numberOfSpaces); ++i) {
                System.out.print(" ");
            }
            System.out.println(tool.getShortDescription());
        }
    }

    public static Set<String> getToolNames() {
        return toolLookupMap.keySet();
    }

    public static void main(String[] args) {
        block14: {
            if (args.length == 0) {
                CLI.usage();
                System.exit(0);
            }
            String[] toolArguments = new String[args.length - 1];
            System.arraycopy(args, 1, toolArguments, 0, toolArguments.length);
            String toolName = args[0];
            String formatName = DEFAULT_FORMAT;
            int idx = toolName.indexOf(".");
            if (-1 < idx) {
                formatName = toolName.substring(idx + 1);
                toolName = toolName.substring(0, idx);
            }
            CmdLineTool tool = toolLookupMap.get(toolName);
            try {
                if (null == tool) {
                    throw new TerminateToolException(1, "Tool " + toolName + " is not found.");
                }
                if (0 == toolArguments.length && tool.hasParams() || 0 < toolArguments.length && "help".equals(toolArguments[0])) {
                    if (tool instanceof TypedCmdLineTool) {
                        System.out.println(((TypedCmdLineTool)tool).getHelp(formatName));
                    } else if (tool instanceof BasicCmdLineTool) {
                        System.out.println(tool.getHelp());
                    }
                    System.exit(0);
                }
                if (tool instanceof TypedCmdLineTool) {
                    ((TypedCmdLineTool)tool).run(formatName, toolArguments);
                    break block14;
                }
                if (tool instanceof BasicCmdLineTool) {
                    if (-1 == idx) {
                        ((BasicCmdLineTool)tool).run(toolArguments);
                        break block14;
                    }
                    throw new TerminateToolException(1, "Tool " + toolName + " does not support formats.");
                }
                throw new TerminateToolException(1, "Tool " + toolName + " is not supported.");
            }
            catch (TerminateToolException e) {
                if (e.getMessage() != null) {
                    System.err.println(e.getMessage());
                }
                if (e.getCause() != null) {
                    System.err.println(e.getCause().getMessage());
                    e.getCause().printStackTrace(System.err);
                }
                System.exit(e.getCode());
            }
        }
    }

    static {
        LinkedList<Object> tools = new LinkedList<Object>();
        tools.add((Object)new AgeClassifyTrainerTool());
        tools.add((Object)new AgeClassifyTool());
        tools.add((Object)new AgeClassifyEvaluatorTool());
        tools.add((Object)new AgeClassifySparkTrainerTool());
        tools.add((Object)new AgeClassifySparkEvaluatorTool());
        tools.add((Object)new AgePredictTrainerTool());
        tools.add(new AgePredictTool());
        tools.add((Object)new AgePredictEvaluatorTool());
        AuthorAgeSampleStreamFactory.registerFactory();
        for (CmdLineTool cmdLineTool : tools) {
            toolLookupMap.put(cmdLineTool.getName(), cmdLineTool);
        }
        toolLookupMap = Collections.unmodifiableMap(toolLookupMap);
    }
}

