/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline.authorage;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import opennlp.tools.authorage.AgeClassifyME;
import opennlp.tools.authorage.AgeClassifyModel;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class AgeClassifyTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "age classifier";
    }

    public String getHelp() {
        return "Usage: bin/authorage " + this.getName() + " model < documents";
    }

    public void run(String[] args) {
        if (0 == args.length) {
            System.out.println(this.getHelp());
        } else {
            AgeClassifyModel model;
            try {
                model = new AgeClassifyModel(new File(args[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            AgeClassifyME classify = new AgeClassifyME(model);
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "doc");
            perfMon.start();
            try {
                String document;
                ParagraphStream documentStream = new ParagraphStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding()));
                while ((document = (String)documentStream.read()) != null) {
                    Object[] tokens = model.getFactory().getTokenizer().tokenize(document);
                    double[] prob = classify.getProbabilities((String[])tokens);
                    String category = classify.getBestCategory(prob);
                    System.out.println(Arrays.toString(tokens));
                    System.out.println(category);
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError((IOException)e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

