/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.cmdline.spark.authorage;

import edu.usc.irds.agepredictor.cmdline.params.PredictTrainingToolParams;
import edu.usc.irds.agepredictor.spark.authorage.AgeClassifyContextGeneratorWrapper;
import edu.usc.irds.agepredictor.spark.authorage.AgePredictModel;
import edu.usc.irds.agepredictor.spark.authorage.AgePredictSGDTrainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.BagOfWordsFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGenerator;
import org.apache.spark.sql.SparkSession;

public class AgePredictTrainerTool
extends BasicCmdLineTool {
    private Class paramsClass = PredictTrainingToolParams.class;
    private PredictTrainingToolParams params;

    public String getShortDescription() {
        return "trainer for the age predictor";
    }

    public String getHelp() {
        return "Usage: bin/authorage " + this.getName() + " " + ArgumentParser.createUsage((Class)this.paramsClass);
    }

    public void run(String[] args) {
        AgePredictModel model;
        String errMessage = ArgumentParser.validateArgumentsLoudly((String[])args, (Class)this.paramsClass);
        if (null != errMessage) {
            throw new TerminateToolException(1, errMessage + "\n" + this.getHelp());
        }
        SparkSession spark = SparkSession.builder().appName("AgePredictTrainer").getOrCreate();
        this.params = (PredictTrainingToolParams)ArgumentParser.parse((String[])ArgumentParser.filter((String[])args, (Class)this.paramsClass), (Class)this.paramsClass);
        System.out.println("Feature Generators: " + this.params.getFeatureGenerators());
        System.out.println("Tokenizer: " + this.params.getTokenizer());
        try {
            AgePredictSGDTrainer.generateEvents(spark, this.params.getData(), this.params.getTokenizer(), this.params.getFeatureGenerators(), this.params.getEvents());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
        AgeClassifyContextGeneratorWrapper wrapper = new AgeClassifyContextGeneratorWrapper(this.params.getTokenizer(), this.params.getFeatureGenerators());
        FeatureGenerator[] featureGenerators = wrapper.getFeatureGenerators();
        Tokenizer tokenizer = wrapper.getTokenizer();
        TrainingParameters mlParams = null;
        String paramFile = this.params.getParams();
        if (paramFile != null) {
            CmdLineUtil.checkInputFile((String)"Training Parameter", (File)new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                mlParams = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (mlParams == null) {
            mlParams = new TrainingParameters();
            mlParams.put("Iterations", Integer.toString(100));
            mlParams.put("Cutoff", Integer.toString(5));
        }
        File modelOutFile = this.params.getModel();
        try {
            model = AgePredictSGDTrainer.createModel(this.params.getLang(), spark, this.params.getEvents(), wrapper, mlParams);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
        AgePredictModel.writeModel(model, modelOutFile);
        spark.stop();
    }

    private static Tokenizer createTokenizer(String tokenizer) {
        if (tokenizer != null) {
            return (Tokenizer)ExtensionLoader.instantiateExtension(Tokenizer.class, (String)tokenizer);
        }
        return WhitespaceTokenizer.INSTANCE;
    }

    private static FeatureGenerator[] createFeatureGenerators(String featureGeneratorsNames) {
        if (featureGeneratorsNames == null) {
            FeatureGenerator[] def = new FeatureGenerator[]{new BagOfWordsFeatureGenerator()};
            return def;
        }
        String[] classes = featureGeneratorsNames.split(",");
        FeatureGenerator[] featureGenerators = new FeatureGenerator[classes.length];
        for (int i = 0; i < featureGenerators.length; ++i) {
            featureGenerators[i] = (FeatureGenerator)ExtensionLoader.instantiateExtension(FeatureGenerator.class, (String)classes[i]);
        }
        return featureGenerators;
    }
}

