/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.spark.authorage;

import edu.usc.irds.agepredictor.spark.authorage.AgeClassifyContextGeneratorWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.mllib.regression.LassoModel;

public class AgePredictModel
implements Serializable {
    private String languageCode;
    private LassoModel model;
    private String[] vocabulary;
    private AgeClassifyContextGeneratorWrapper wrapper;

    public AgePredictModel(String languageCode, LassoModel agePredictModel, String[] vocabulary, AgeClassifyContextGeneratorWrapper wrapper) {
        this.languageCode = languageCode;
        this.model = agePredictModel;
        this.vocabulary = vocabulary;
        this.wrapper = wrapper;
    }

    public static AgePredictModel readModel(File file) throws IOException {
        try {
            FileInputStream fin = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fin);
            AgePredictModel model = (AgePredictModel)ois.readObject();
            ois.close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AgeClassifyContextGeneratorWrapper getContext() {
        return this.wrapper;
    }

    public LassoModel getModel() {
        return this.model;
    }

    public String[] getVocabulary() {
        return this.vocabulary;
    }

    public static void writeModel(AgePredictModel model, File file) {
        try {
            FileOutputStream fout = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            oos.writeObject(model);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

