/*
 * Decompiled with CFR 0.152.
 */
package edu.usc.irds.agepredictor.spark.authorage;

import java.io.Serializable;
import opennlp.tools.ml.model.Event;

public class EventWrapper
implements Serializable {
    private Integer value;
    private String outcome;
    private String[] context;

    public EventWrapper(Integer outcome, String[] context) {
        this.value = outcome;
        this.outcome = outcome < 18 ? "xx-18" : (outcome >= 18 && outcome <= 24 ? "18-24" : (outcome >= 25 && outcome <= 34 ? "25-34" : (outcome >= 35 && outcome <= 49 ? "35-49" : (outcome >= 50 && outcome <= 64 ? "50-64" : "65-xx"))));
        this.context = context;
    }

    public EventWrapper(String outcome, String[] context) {
        this.outcome = outcome;
        this.context = context;
        this.value = null;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String[] getContext() {
        return this.context;
    }

    public Event getEvent() {
        return new Event(this.outcome, this.context);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value).append(",");
        } else {
            sb.append("-1").append(",");
        }
        sb.append(this.outcome).append(",");
        if (this.context.length > 0) {
            sb.append(this.context[0]);
        }
        for (int ci = 1; ci < this.context.length; ++ci) {
            sb.append(" ").append(this.context[ci]);
        }
        return sb.toString();
    }
}

