/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;

public class SentenceTokenizer
implements Tokenizer {
    public static final SentenceTokenizer INSTANCE = new SentenceTokenizer();
    private final String TOKEN_MODEL_FILE = "model/opennlp/en-token.bin";
    private final String SENTENCE_MODEL_FILE = "model/opennlp/en-sent.bin";

    private SentenceTokenizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] tokenize(String s) {
        FileInputStream modelIn = null;
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            String[] sentences;
            modelIn = new FileInputStream("model/opennlp/en-sent.bin");
            SentenceModel model = new SentenceModel((InputStream)modelIn);
            SentenceDetectorME sentenceDetector = new SentenceDetectorME(model);
            for (String sentence : sentences = sentenceDetector.sentDetect(s)) {
                List<String> toks = Arrays.asList(this.tokenizeHelper(sentence));
                tokens.addAll(toks);
                tokens.add("<SENTENCE>");
            }
        }
        catch (IOException e) {
            System.out.println("Error with loading Sentence model...");
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] tokenizeHelper(String s) {
        FileInputStream modelIn = null;
        String[] tokens = new String[]{};
        try {
            modelIn = new FileInputStream("model/opennlp/en-token.bin");
            TokenizerModel model = new TokenizerModel((InputStream)modelIn);
            TokenizerME tokenizer = new TokenizerME(model);
            tokens = tokenizer.tokenize(s);
        }
        catch (IOException e) {
            System.out.println("Error with loading Tokenizer Model...");
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    ((InputStream)modelIn).close();
                }
                catch (IOException iOException) {}
            }
        }
        return tokens;
    }

    public Span[] tokenizePos(String s) {
        return new Span[0];
    }
}

